package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.wms.moveorder.querywithdetail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtWmsMoveorderQuerywithdetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1233772486174842431L;

	/** 
	 * 单据数据 库存相关数据
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码 返回0为正常
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 移位单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailList {

	/**
		 * 条码
		 */
		@ApiField("barcode")
		private String barcode;
		/**
		 * 批次
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 是否残品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 源货位
		 */
		@ApiField("from_position_no")
		private String fromPositionNo;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 移位数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 移位单id
		 */
		@ApiField("order_id")
		private Long orderId;
		/**
		 * 简称
		 */
		@ApiField("short_name")
		private String shortName;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 单品id
		 */
		@ApiField("spec_id")
		private Long specId;
		/**
		 * 单品名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 目标货位
		 */
		@ApiField("to_position_no")
		private String toPositionNo;
	

	public String getBarcode() {
			return this.barcode;
		}
		public void setBarcode(String barcode) {
			this.barcode = barcode;
		}
		public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getFromPositionNo() {
			return this.fromPositionNo;
		}
		public void setFromPositionNo(String fromPositionNo) {
			this.fromPositionNo = fromPositionNo;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public Long getOrderId() {
			return this.orderId;
		}
		public void setOrderId(Long orderId) {
			this.orderId = orderId;
		}
		public String getShortName() {
			return this.shortName;
		}
		public void setShortName(String shortName) {
			this.shortName = shortName;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public Long getSpecId() {
			return this.specId;
		}
		public void setSpecId(Long specId) {
			this.specId = specId;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getToPositionNo() {
			return this.toPositionNo;
		}
		public void setToPositionNo(String toPositionNo) {
			this.toPositionNo = toPositionNo;
		}

}

	/**
 * 单据数据 库存信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 制单人
		 */
		@ApiField("creator_name")
		private String creatorName;
		/**
		 * 移位单明细
		 */
		@ApiListField("detail_list")
		@ApiField("detailList")
		private List<DetailList> detailList;
		/**
		 * 修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 移位单号
		 */
		@ApiField("order_no")
		private String orderNo;
		/**
		 * 移位单ID
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 移位单备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 状态 5:已取消,10:待审核,20:已审核
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 类型 1 采购入库上架,2 补货上架,3 销退上架,4 拣货放回,5 货位清点,6 拣货下架,8 清点处理,10 其它入库上架,11 补货下架,12 补货放回, 15 其它下架,16 其它上架,17 销退质检上架
		 */
		@ApiField("type")
		private Long type;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public String getCreatorName() {
			return this.creatorName;
		}
		public void setCreatorName(String creatorName) {
			this.creatorName = creatorName;
		}
		public List<DetailList> getDetailList() {
			return this.detailList;
		}
		public void setDetailList(List<DetailList> detailList) {
			this.detailList = detailList;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getOrderNo() {
			return this.orderNo;
		}
		public void setOrderNo(String orderNo) {
			this.orderNo = orderNo;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getType() {
			return this.type;
		}
		public void setType(Long type) {
			this.type = type;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 单据数据 库存相关数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据数据 库存信息列表
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 总数 查询条件总单据数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
