package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockin.purchase.querywithdetail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtWmsStockinPurchaseQuerywithdetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 7875585638836277832L;

	/** 
	 * 单据数据
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 入库单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailsList {

	/**
		 * 批次（若无批次则返回空字符串）
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 品牌名称
		 */
		@ApiField("brand_name")
		private String brandName;
		/**
		 * 单价
		 */
		@ApiField("cost_price")
		private String costPrice;
		/**
		 * 是否残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 折扣
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 有效期 （若无有效期则返回空字符串）
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 基本单位
		 */
		@ApiField("goods_unit")
		private String goodsUnit;
		/**
		 * 数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 货位编号
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 生产日期
		 */
		@ApiField("production_date")
		private String productionDate;
		/**
		 * 采购明细自定义属性1
		 */
		@ApiField("prop1")
		private String prop1;
		/**
		 * 规格自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 采购明细自定义属性3
		 */
		@ApiField("prop3")
		private String prop3;
		/**
		 * 采购明细自定义属性4
		 */
		@ApiField("prop4")
		private String prop4;
		/**
		 * 辅助单位
		 */
		@ApiField("purchase_unit_name")
		private String purchaseUnitName;
		/**
		 * 入库明细唯一id
		 */
		@ApiField("rec_id")
		private String recId;
		/**
		 * 入库单明细备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 校准数量
		 */
		@ApiField("right_num")
		private String rightNum;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 规格名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 折后价
		 */
		@ApiField("src_price")
		private String srcPrice;
		/**
		 * 入库单id
		 */
		@ApiField("stockin_id")
		private Long stockinId;
		/**
		 * 税率
		 */
		@ApiField("tax")
		private String tax;
		/**
		 * 税后总价
		 */
		@ApiField("tax_amount")
		private String taxAmount;
		/**
		 * 税后价(折后加税率)
		 */
		@ApiField("tax_price")
		private String taxPrice;
		/**
		 * 折后总价
		 */
		@ApiField("total_cost")
		private String totalCost;
		/**
		 * 基本单位
		 */
		@ApiField("unit_name")
		private String unitName;
		/**
		 * 换算系数
		 */
		@ApiField("unit_ratio")
		private String unitRatio;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getBrandName() {
			return this.brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getCostPrice() {
			return this.costPrice;
		}
		public void setCostPrice(String costPrice) {
			this.costPrice = costPrice;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public String getGoodsUnit() {
			return this.goodsUnit;
		}
		public void setGoodsUnit(String goodsUnit) {
			this.goodsUnit = goodsUnit;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public String getProductionDate() {
			return this.productionDate;
		}
		public void setProductionDate(String productionDate) {
			this.productionDate = productionDate;
		}
		public String getProp1() {
			return this.prop1;
		}
		public void setProp1(String prop1) {
			this.prop1 = prop1;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public String getProp3() {
			return this.prop3;
		}
		public void setProp3(String prop3) {
			this.prop3 = prop3;
		}
		public String getProp4() {
			return this.prop4;
		}
		public void setProp4(String prop4) {
			this.prop4 = prop4;
		}
		public String getPurchaseUnitName() {
			return this.purchaseUnitName;
		}
		public void setPurchaseUnitName(String purchaseUnitName) {
			this.purchaseUnitName = purchaseUnitName;
		}
		public String getRecId() {
			return this.recId;
		}
		public void setRecId(String recId) {
			this.recId = recId;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getRightNum() {
			return this.rightNum;
		}
		public void setRightNum(String rightNum) {
			this.rightNum = rightNum;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getSrcPrice() {
			return this.srcPrice;
		}
		public void setSrcPrice(String srcPrice) {
			this.srcPrice = srcPrice;
		}
		public Long getStockinId() {
			return this.stockinId;
		}
		public void setStockinId(Long stockinId) {
			this.stockinId = stockinId;
		}
		public String getTax() {
			return this.tax;
		}
		public void setTax(String tax) {
			this.tax = tax;
		}
		public String getTaxAmount() {
			return this.taxAmount;
		}
		public void setTaxAmount(String taxAmount) {
			this.taxAmount = taxAmount;
		}
		public String getTaxPrice() {
			return this.taxPrice;
		}
		public void setTaxPrice(String taxPrice) {
			this.taxPrice = taxPrice;
		}
		public String getTotalCost() {
			return this.totalCost;
		}
		public void setTotalCost(String totalCost) {
			this.totalCost = totalCost;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}
		public String getUnitRatio() {
			return this.unitRatio;
		}
		public void setUnitRatio(String unitRatio) {
			this.unitRatio = unitRatio;
		}

}

	/**
 * 入库单相关数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 入库单审核时间
		 */
		@ApiField("check_time")
		private String checkTime;
		/**
		 * 建单时间
		 */
		@ApiField("created_time")
		private String createdTime;
		/**
		 * 入库单明细
		 */
		@ApiListField("details_list")
		@ApiField("detailsList")
		private List<DetailsList> detailsList;
		/**
		 * 标记
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 货品总价格，不包含优惠
		 */
		@ApiField("goods_amount")
		private String goodsAmount;
		/**
		 * 入库单货品总数
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 物流公司编号
		 */
		@ApiField("logistics_code")
		private String logisticsCode;
		/**
		 * 入库单物流名称
		 */
		@ApiField("logistics_name")
		private String logisticsName;
		/**
		 * 入库单物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 入库单物流类型
		 */
		@ApiField("logistics_type")
		private Long logisticsType;
		/**
		 * 物流类型
		 */
		@ApiField("logistics_type_name")
		private String logisticsTypeName;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 经办人
		 */
		@ApiField("operator_name")
		private String operatorName;
		/**
		 * 入库单号
		 */
		@ApiField("order_no")
		private String orderNo;
		/**
		 * 外部单号
		 */
		@ApiField("outer_no")
		private String outerNo;
		/**
		 * 供应商名称
		 */
		@ApiField("provider_name")
		private String providerName;
		/**
		 * 供应商编号
		 */
		@ApiField("provider_no")
		private String providerNo;
		/**
		 * 采购单id
		 */
		@ApiField("purchase_id")
		private Long purchaseId;
		/**
		 * 采购单编号
		 */
		@ApiField("purchase_no")
		private String purchaseNo;
		/**
		 * 入库单备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 序号
		 */
		@ApiField("seq_no")
		private Long seqNo;
		/**
		 * 入库单状态（10:已取消,20编辑中,30:待审核,37:待质检,40:质检确认,80:已完成）
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 入库单id
		 */
		@ApiField("stockin_id")
		private Long stockinId;
		/**
		 * 税后总额
		 */
		@ApiField("tax_amount")
		private String taxAmount;
		/**
		 * 折后总额
		 */
		@ApiField("total_price")
		private String totalPrice;
		/**
		 * 入库总金额
		 */
		@ApiField("total_stockin_price")
		private String totalStockinPrice;
		/**
		 * 仓库名称
		 */
		@ApiField("warehouse_name")
		private String warehouseName;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getCheckTime() {
			return this.checkTime;
		}
		public void setCheckTime(String checkTime) {
			this.checkTime = checkTime;
		}
		public String getCreatedTime() {
			return this.createdTime;
		}
		public void setCreatedTime(String createdTime) {
			this.createdTime = createdTime;
		}
		public List<DetailsList> getDetailsList() {
			return this.detailsList;
		}
		public void setDetailsList(List<DetailsList> detailsList) {
			this.detailsList = detailsList;
		}
		public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public String getGoodsAmount() {
			return this.goodsAmount;
		}
		public void setGoodsAmount(String goodsAmount) {
			this.goodsAmount = goodsAmount;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public Long getLogisticsType() {
			return this.logisticsType;
		}
		public void setLogisticsType(Long logisticsType) {
			this.logisticsType = logisticsType;
		}
		public String getLogisticsTypeName() {
			return this.logisticsTypeName;
		}
		public void setLogisticsTypeName(String logisticsTypeName) {
			this.logisticsTypeName = logisticsTypeName;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getOperatorName() {
			return this.operatorName;
		}
		public void setOperatorName(String operatorName) {
			this.operatorName = operatorName;
		}
		public String getOrderNo() {
			return this.orderNo;
		}
		public void setOrderNo(String orderNo) {
			this.orderNo = orderNo;
		}
		public String getOuterNo() {
			return this.outerNo;
		}
		public void setOuterNo(String outerNo) {
			this.outerNo = outerNo;
		}
		public String getProviderName() {
			return this.providerName;
		}
		public void setProviderName(String providerName) {
			this.providerName = providerName;
		}
		public String getProviderNo() {
			return this.providerNo;
		}
		public void setProviderNo(String providerNo) {
			this.providerNo = providerNo;
		}
		public Long getPurchaseId() {
			return this.purchaseId;
		}
		public void setPurchaseId(Long purchaseId) {
			this.purchaseId = purchaseId;
		}
		public String getPurchaseNo() {
			return this.purchaseNo;
		}
		public void setPurchaseNo(String purchaseNo) {
			this.purchaseNo = purchaseNo;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public Long getSeqNo() {
			return this.seqNo;
		}
		public void setSeqNo(Long seqNo) {
			this.seqNo = seqNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getStockinId() {
			return this.stockinId;
		}
		public void setStockinId(Long stockinId) {
			this.stockinId = stockinId;
		}
		public String getTaxAmount() {
			return this.taxAmount;
		}
		public void setTaxAmount(String taxAmount) {
			this.taxAmount = taxAmount;
		}
		public String getTotalPrice() {
			return this.totalPrice;
		}
		public void setTotalPrice(String totalPrice) {
			this.totalPrice = totalPrice;
		}
		public String getTotalStockinPrice() {
			return this.totalStockinPrice;
		}
		public void setTotalStockinPrice(String totalStockinPrice) {
			this.totalStockinPrice = totalStockinPrice;
		}
		public String getWarehouseName() {
			return this.warehouseName;
		}
		public void setWarehouseName(String warehouseName) {
			this.warehouseName = warehouseName;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 入库单相关数据
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 查询条件总单据数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
