package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockout.purchasereturn.querywithdetail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtWmsStockoutPurchasereturnQuerywithdetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2716871924338323482L;

	/** 
	 * 返回值
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码,返回0为正常
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 货位明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class PositionDetailsList {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 当前货位出库总数量
		 */
		@ApiField("position_goods_count")
		private String positionGoodsCount;
		/**
		 * 货位id
		 */
		@ApiField("position_id")
		private Long positionId;
		/**
		 * 货位编号
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 货位明细主键
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 出库明细id
		 */
		@ApiField("stockout_detail_id")
		private Long stockoutDetailId;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getPositionGoodsCount() {
			return this.positionGoodsCount;
		}
		public void setPositionGoodsCount(String positionGoodsCount) {
			this.positionGoodsCount = positionGoodsCount;
		}
		public Long getPositionId() {
			return this.positionId;
		}
		public void setPositionId(Long positionId) {
			this.positionId = positionId;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public Long getStockoutDetailId() {
			return this.stockoutDetailId;
		}
		public void setStockoutDetailId(Long stockoutDetailId) {
			this.stockoutDetailId = stockoutDetailId;
		}

}

	/**
 * 出库单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailsList {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 品牌名称
		 */
		@ApiField("brand_name")
		private String brandName;
		/**
		 * 品牌编号
		 */
		@ApiField("brand_no")
		private String brandNo;
		/**
		 * 成本价
		 */
		@ApiField("cost_price")
		private String costPrice;
		/**
		 * 残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 有效期（如果没有则返回空字符串）
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 货品数量
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 货品类型
		 */
		@ApiField("goods_type")
		private Long goodsType;
		/**
		 * 单位
		 */
		@ApiField("goods_unit")
		private String goodsUnit;
		/**
		 * 货位明细
		 */
		@ApiListField("position_details_list")
		@ApiField("positionDetailsList")
		private List<PositionDetailsList> positionDetailsList;
		/**
		 * 默认货位货品数，传入参数（position）不为0时返回
		 */
		@ApiField("position_goods_count")
		private Long positionGoodsCount;
		/**
		 * 货位编号
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 自定义属性1
		 */
		@ApiField("prop1")
		private String prop1;
		/**
		 * 自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 出库单明细ID（主键）
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 折后价
		 */
		@ApiField("sell_price")
		private String sellPrice;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 规格名
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 出库单ID
		 */
		@ApiField("stockout_id")
		private Long stockoutId;
		/**
		 * 货品总额
		 */
		@ApiField("total_amount")
		private String totalAmount;
		/**
		 * 总瞬时实际成本
		 */
		@ApiField("total_checked_cost_price")
		private String totalCheckedCostPrice;
		/**
		 * 重量
		 */
		@ApiField("weight")
		private String weight;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getBrandName() {
			return this.brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getBrandNo() {
			return this.brandNo;
		}
		public void setBrandNo(String brandNo) {
			this.brandNo = brandNo;
		}
		public String getCostPrice() {
			return this.costPrice;
		}
		public void setCostPrice(String costPrice) {
			this.costPrice = costPrice;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public Long getGoodsType() {
			return this.goodsType;
		}
		public void setGoodsType(Long goodsType) {
			this.goodsType = goodsType;
		}
		public String getGoodsUnit() {
			return this.goodsUnit;
		}
		public void setGoodsUnit(String goodsUnit) {
			this.goodsUnit = goodsUnit;
		}
		public List<PositionDetailsList> getPositionDetailsList() {
			return this.positionDetailsList;
		}
		public void setPositionDetailsList(List<PositionDetailsList> positionDetailsList) {
			this.positionDetailsList = positionDetailsList;
		}
		public Long getPositionGoodsCount() {
			return this.positionGoodsCount;
		}
		public void setPositionGoodsCount(Long positionGoodsCount) {
			this.positionGoodsCount = positionGoodsCount;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public String getProp1() {
			return this.prop1;
		}
		public void setProp1(String prop1) {
			this.prop1 = prop1;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSellPrice() {
			return this.sellPrice;
		}
		public void setSellPrice(String sellPrice) {
			this.sellPrice = sellPrice;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public Long getStockoutId() {
			return this.stockoutId;
		}
		public void setStockoutId(Long stockoutId) {
			this.stockoutId = stockoutId;
		}
		public String getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(String totalAmount) {
			this.totalAmount = totalAmount;
		}
		public String getTotalCheckedCostPrice() {
			return this.totalCheckedCostPrice;
		}
		public void setTotalCheckedCostPrice(String totalCheckedCostPrice) {
			this.totalCheckedCostPrice = totalCheckedCostPrice;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 瞬时成本总额
		 */
		@ApiField("checked_goods_total_cost")
		private String checkedGoodsTotalCost;
		/**
		 * 发货时间
		 */
		@ApiField("consign_time")
		private String consignTime;
		/**
		 * 创建时间
		 */
		@ApiField("create_time")
		private String createTime;
		/**
		 * 出库单明细
		 */
		@ApiListField("details_list")
		@ApiField("detailsList")
		private List<DetailsList> detailsList;
		/**
		 * 货品数量
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 总货款
		 */
		@ApiField("goods_total_amount")
		private String goodsTotalAmount;
		/**
		 * 总成本价,所有明细cost_price*goods_count的和
		 */
		@ApiField("goods_total_cost")
		private String goodsTotalCost;
		/**
		 * 货品种类数
		 */
		@ApiField("goods_type_count")
		private Long goodsTypeCount;
		/**
		 * 最后一次引用的采购单号
		 */
		@ApiField("last_load_purchase_no")
		private String lastLoadPurchaseNo;
		/**
		 * 物流编号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 制单人
		 */
		@ApiField("operator_name")
		private String operatorName;
		/**
		 * 出库单号
		 */
		@ApiField("order_no")
		private String orderNo;
		/**
		 * 包装费
		 */
		@ApiField("package_fee")
		private String packageFee;
		/**
		 * 预估邮费
		 */
		@ApiField("post_fee")
		private String postFee;
		/**
		 * 供应商名称
		 */
		@ApiField("provider_name")
		private String providerName;
		/**
		 * 供应商编号
		 */
		@ApiField("provider_no")
		private String providerNo;
		/**
		 * 收件人地址
		 */
		@ApiField("receiver_address")
		private String receiverAddress;
		/**
		 * 城市id
		 */
		@ApiField("receiver_city")
		private String receiverCity;
		/**
		 * 地区id
		 */
		@ApiField("receiver_district")
		private String receiverDistrict;
		/**
		 * 收货人姓名
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 省份id
		 */
		@ApiField("receiver_province")
		private String receiverProvince;
		/**
		 * 固话
		 */
		@ApiField("receiver_telno")
		private String receiverTelno;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 采购退货单号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 出库单状态
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 出库单id
		 */
		@ApiField("stockout_id")
		private Long stockoutId;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
		/**
		 * 重量
		 */
		@ApiField("weight")
		private String weight;
	

	public String getCheckedGoodsTotalCost() {
			return this.checkedGoodsTotalCost;
		}
		public void setCheckedGoodsTotalCost(String checkedGoodsTotalCost) {
			this.checkedGoodsTotalCost = checkedGoodsTotalCost;
		}
		public String getConsignTime() {
			return this.consignTime;
		}
		public void setConsignTime(String consignTime) {
			this.consignTime = consignTime;
		}
		public String getCreateTime() {
			return this.createTime;
		}
		public void setCreateTime(String createTime) {
			this.createTime = createTime;
		}
		public List<DetailsList> getDetailsList() {
			return this.detailsList;
		}
		public void setDetailsList(List<DetailsList> detailsList) {
			this.detailsList = detailsList;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public String getGoodsTotalAmount() {
			return this.goodsTotalAmount;
		}
		public void setGoodsTotalAmount(String goodsTotalAmount) {
			this.goodsTotalAmount = goodsTotalAmount;
		}
		public String getGoodsTotalCost() {
			return this.goodsTotalCost;
		}
		public void setGoodsTotalCost(String goodsTotalCost) {
			this.goodsTotalCost = goodsTotalCost;
		}
		public Long getGoodsTypeCount() {
			return this.goodsTypeCount;
		}
		public void setGoodsTypeCount(Long goodsTypeCount) {
			this.goodsTypeCount = goodsTypeCount;
		}
		public String getLastLoadPurchaseNo() {
			return this.lastLoadPurchaseNo;
		}
		public void setLastLoadPurchaseNo(String lastLoadPurchaseNo) {
			this.lastLoadPurchaseNo = lastLoadPurchaseNo;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getOperatorName() {
			return this.operatorName;
		}
		public void setOperatorName(String operatorName) {
			this.operatorName = operatorName;
		}
		public String getOrderNo() {
			return this.orderNo;
		}
		public void setOrderNo(String orderNo) {
			this.orderNo = orderNo;
		}
		public String getPackageFee() {
			return this.packageFee;
		}
		public void setPackageFee(String packageFee) {
			this.packageFee = packageFee;
		}
		public String getPostFee() {
			return this.postFee;
		}
		public void setPostFee(String postFee) {
			this.postFee = postFee;
		}
		public String getProviderName() {
			return this.providerName;
		}
		public void setProviderName(String providerName) {
			this.providerName = providerName;
		}
		public String getProviderNo() {
			return this.providerNo;
		}
		public void setProviderNo(String providerNo) {
			this.providerNo = providerNo;
		}
		public String getReceiverAddress() {
			return this.receiverAddress;
		}
		public void setReceiverAddress(String receiverAddress) {
			this.receiverAddress = receiverAddress;
		}
		public String getReceiverCity() {
			return this.receiverCity;
		}
		public void setReceiverCity(String receiverCity) {
			this.receiverCity = receiverCity;
		}
		public String getReceiverDistrict() {
			return this.receiverDistrict;
		}
		public void setReceiverDistrict(String receiverDistrict) {
			this.receiverDistrict = receiverDistrict;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public String getReceiverProvince() {
			return this.receiverProvince;
		}
		public void setReceiverProvince(String receiverProvince) {
			this.receiverProvince = receiverProvince;
		}
		public String getReceiverTelno() {
			return this.receiverTelno;
		}
		public void setReceiverTelno(String receiverTelno) {
			this.receiverTelno = receiverTelno;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getStockoutId() {
			return this.stockoutId;
		}
		public void setStockoutId(Long stockoutId) {
			this.stockoutId = stockoutId;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}

}

	/**
 * 返回值
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据数据
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 总数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
