package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockout.transfer.querywithdetail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtWmsStockoutTransferQuerywithdetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5247758884648276917L;

	/** 
	 * 单据信息
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息 无错误信息不返回
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码 返回0为正常
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 货位明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class PositionDetailsList {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 当前货位出库总货品数量
		 */
		@ApiField("position_goods_count")
		private String positionGoodsCount;
		/**
		 * 货位id
		 */
		@ApiField("position_id")
		private Long positionId;
		/**
		 * 货位号
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 货位明细id
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 出库单明细id
		 */
		@ApiField("stockout_detail_id")
		private Long stockoutDetailId;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getPositionGoodsCount() {
			return this.positionGoodsCount;
		}
		public void setPositionGoodsCount(String positionGoodsCount) {
			this.positionGoodsCount = positionGoodsCount;
		}
		public Long getPositionId() {
			return this.positionId;
		}
		public void setPositionId(Long positionId) {
			this.positionId = positionId;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public Long getStockoutDetailId() {
			return this.stockoutDetailId;
		}
		public void setStockoutDetailId(Long stockoutDetailId) {
			this.stockoutDetailId = stockoutDetailId;
		}

}

	/**
 * 出库单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailList {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 品牌名称
		 */
		@ApiField("brand_name")
		private String brandName;
		/**
		 * 品牌编号
		 */
		@ApiField("brand_no")
		private String brandNo;
		/**
		 * 成本价
		 */
		@ApiField("cost_price")
		private String costPrice;
		/**
		 * 是否残次品 true:  残次品 false:  正品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 货品数量
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编码
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 货品类型 1销售商品  2原材料  3包装  4周转材料 5虚拟商品 6固定资产  0其它
		 */
		@ApiField("goods_type")
		private Long goodsType;
		/**
		 * 货品单位
		 */
		@ApiField("goods_unit")
		private String goodsUnit;
		/**
		 * 货位明细
		 */
		@ApiListField("position_details_list")
		@ApiField("positionDetailsList")
		private List<PositionDetailsList> positionDetailsList;
		/**
		 * 当前货位出库的总数量
		 */
		@ApiField("position_goods_count")
		private String positionGoodsCount;
		/**
		 * 货位ID
		 */
		@ApiField("position_id")
		private Long positionId;
		/**
		 * 货位编号
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 出库单详情id
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 出库单详情备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 成交价
		 */
		@ApiField("sell_price")
		private String sellPrice;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 规格名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 调拨单详情备注
		 */
		@ApiField("std_remark")
		private String stdRemark;
		/**
		 * 出库单id
		 */
		@ApiField("stockout_id")
		private Long stockoutId;
		/**
		 * 总成本 总成本:  如果平均成本为空或者小于0,就使用计划成本; 如果按照货位分组就是总成本
		 */
		@ApiField("total_amount")
		private String totalAmount;
		/**
		 * 货品规格单位
		 */
		@ApiField("unit_name")
		private String unitName;
		/**
		 * 总重量
		 */
		@ApiField("weight")
		private String weight;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getBrandName() {
			return this.brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getBrandNo() {
			return this.brandNo;
		}
		public void setBrandNo(String brandNo) {
			this.brandNo = brandNo;
		}
		public String getCostPrice() {
			return this.costPrice;
		}
		public void setCostPrice(String costPrice) {
			this.costPrice = costPrice;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public Long getGoodsType() {
			return this.goodsType;
		}
		public void setGoodsType(Long goodsType) {
			this.goodsType = goodsType;
		}
		public String getGoodsUnit() {
			return this.goodsUnit;
		}
		public void setGoodsUnit(String goodsUnit) {
			this.goodsUnit = goodsUnit;
		}
		public List<PositionDetailsList> getPositionDetailsList() {
			return this.positionDetailsList;
		}
		public void setPositionDetailsList(List<PositionDetailsList> positionDetailsList) {
			this.positionDetailsList = positionDetailsList;
		}
		public String getPositionGoodsCount() {
			return this.positionGoodsCount;
		}
		public void setPositionGoodsCount(String positionGoodsCount) {
			this.positionGoodsCount = positionGoodsCount;
		}
		public Long getPositionId() {
			return this.positionId;
		}
		public void setPositionId(Long positionId) {
			this.positionId = positionId;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSellPrice() {
			return this.sellPrice;
		}
		public void setSellPrice(String sellPrice) {
			this.sellPrice = sellPrice;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getStdRemark() {
			return this.stdRemark;
		}
		public void setStdRemark(String stdRemark) {
			this.stdRemark = stdRemark;
		}
		public Long getStockoutId() {
			return this.stockoutId;
		}
		public void setStockoutId(Long stockoutId) {
			this.stockoutId = stockoutId;
		}
		public String getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(String totalAmount) {
			this.totalAmount = totalAmount;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 出库时间
		 */
		@ApiField("consign_time")
		private String consignTime;
		/**
		 * 出库单明细
		 */
		@ApiListField("detail_list")
		@ApiField("detailList")
		private List<DetailList> detailList;
		/**
		 * 调出仓库编号
		 */
		@ApiField("from_warehouse_no")
		private String fromWarehouseNo;
		/**
		 * 出库数量
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 总货款
		 */
		@ApiField("goods_total_amount")
		private String goodsTotalAmount;
		/**
		 * 总成本
		 */
		@ApiField("goods_total_cost")
		private String goodsTotalCost;
		/**
		 * 物流单编号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 制单人
		 */
		@ApiField("operator_name")
		private String operatorName;
		/**
		 * 出库单编号
		 */
		@ApiField("order_no")
		private String orderNo;
		/**
		 * 源单据类别 源单据类别 1销售订单 2,调拨出库 3,采购退货出库 4,盘亏出库 5, 生产出库6现款销售出库 7,其他出库
		 */
		@ApiField("order_type")
		private Long orderType;
		/**
		 * 包装成本
		 */
		@ApiField("package_fee")
		private String packageFee;
		/**
		 * 根据重量预估邮费
		 */
		@ApiField("post_fee")
		private String postFee;
		/**
		 * 收件地址
		 */
		@ApiField("receiver_address")
		private String receiverAddress;
		/**
		 * 城市id
		 */
		@ApiField("receiver_city")
		private Long receiverCity;
		/**
		 * 国家id
		 */
		@ApiField("receiver_country")
		private Long receiverCountry;
		/**
		 * 地区id
		 */
		@ApiField("receiver_district")
		private Long receiverDistrict;
		/**
		 * 收件人手机号
		 */
		@ApiField("receiver_mobile")
		private String receiverMobile;
		/**
		 * 收件人姓名
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 省id
		 */
		@ApiField("receiver_province")
		private Long receiverProvince;
		/**
		 * 收件人固话号
		 */
		@ApiField("receiver_telno")
		private String receiverTelno;
		/**
		 * 邮编
		 */
		@ApiField("receiver_zip")
		private String receiverZip;
		/**
		 * 出库单备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 源单号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 调拨单创建时间
		 */
		@ApiField("st_created")
		private String stCreated;
		/**
		 * 外部单号
		 */
		@ApiField("st_outer_no")
		private String stOuterNo;
		/**
		 * 出库单状态
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 出库单id
		 */
		@ApiField("stockout_id")
		private Long stockoutId;
		/**
		 * 调入仓库编号
		 */
		@ApiField("to_warehouse_no")
		private String toWarehouseNo;
		/**
		 * 出库仓编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
		/**
		 * 实际称重重量(Kg)
		 */
		@ApiField("weight")
		private String weight;
	

	public String getConsignTime() {
			return this.consignTime;
		}
		public void setConsignTime(String consignTime) {
			this.consignTime = consignTime;
		}
		public List<DetailList> getDetailList() {
			return this.detailList;
		}
		public void setDetailList(List<DetailList> detailList) {
			this.detailList = detailList;
		}
		public String getFromWarehouseNo() {
			return this.fromWarehouseNo;
		}
		public void setFromWarehouseNo(String fromWarehouseNo) {
			this.fromWarehouseNo = fromWarehouseNo;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public String getGoodsTotalAmount() {
			return this.goodsTotalAmount;
		}
		public void setGoodsTotalAmount(String goodsTotalAmount) {
			this.goodsTotalAmount = goodsTotalAmount;
		}
		public String getGoodsTotalCost() {
			return this.goodsTotalCost;
		}
		public void setGoodsTotalCost(String goodsTotalCost) {
			this.goodsTotalCost = goodsTotalCost;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getOperatorName() {
			return this.operatorName;
		}
		public void setOperatorName(String operatorName) {
			this.operatorName = operatorName;
		}
		public String getOrderNo() {
			return this.orderNo;
		}
		public void setOrderNo(String orderNo) {
			this.orderNo = orderNo;
		}
		public Long getOrderType() {
			return this.orderType;
		}
		public void setOrderType(Long orderType) {
			this.orderType = orderType;
		}
		public String getPackageFee() {
			return this.packageFee;
		}
		public void setPackageFee(String packageFee) {
			this.packageFee = packageFee;
		}
		public String getPostFee() {
			return this.postFee;
		}
		public void setPostFee(String postFee) {
			this.postFee = postFee;
		}
		public String getReceiverAddress() {
			return this.receiverAddress;
		}
		public void setReceiverAddress(String receiverAddress) {
			this.receiverAddress = receiverAddress;
		}
		public Long getReceiverCity() {
			return this.receiverCity;
		}
		public void setReceiverCity(Long receiverCity) {
			this.receiverCity = receiverCity;
		}
		public Long getReceiverCountry() {
			return this.receiverCountry;
		}
		public void setReceiverCountry(Long receiverCountry) {
			this.receiverCountry = receiverCountry;
		}
		public Long getReceiverDistrict() {
			return this.receiverDistrict;
		}
		public void setReceiverDistrict(Long receiverDistrict) {
			this.receiverDistrict = receiverDistrict;
		}
		public String getReceiverMobile() {
			return this.receiverMobile;
		}
		public void setReceiverMobile(String receiverMobile) {
			this.receiverMobile = receiverMobile;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public Long getReceiverProvince() {
			return this.receiverProvince;
		}
		public void setReceiverProvince(Long receiverProvince) {
			this.receiverProvince = receiverProvince;
		}
		public String getReceiverTelno() {
			return this.receiverTelno;
		}
		public void setReceiverTelno(String receiverTelno) {
			this.receiverTelno = receiverTelno;
		}
		public String getReceiverZip() {
			return this.receiverZip;
		}
		public void setReceiverZip(String receiverZip) {
			this.receiverZip = receiverZip;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public String getStCreated() {
			return this.stCreated;
		}
		public void setStCreated(String stCreated) {
			this.stCreated = stCreated;
		}
		public String getStOuterNo() {
			return this.stOuterNo;
		}
		public void setStOuterNo(String stOuterNo) {
			this.stOuterNo = stOuterNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getStockoutId() {
			return this.stockoutId;
		}
		public void setStockoutId(Long stockoutId) {
			this.stockoutId = stockoutId;
		}
		public String getToWarehouseNo() {
			return this.toWarehouseNo;
		}
		public void setToWarehouseNo(String toWarehouseNo) {
			this.toWarehouseNo = toWarehouseNo;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}

}

	/**
 * 单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据数据
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 总数 查询条件总单据数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
