package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;


/**
 * 支付通道计算输入参数
 *
 * @author top auto create
 * @since 1.0, null
 */
public class PayChannelInput extends TaobaoObject {

	private static final long serialVersionUID = 2581447356994231772L;

	/**
	 * 买家淘宝账号ID
	 */
	@ApiField("buyer_id")
	private Long buyerId;

	/**
	 * 淘宝电子凭证代金券
	 */
	@ApiListField("eticket_coupons")
	@ApiField("oto_taobao_coupon")
	private List<OtoTaobaoCoupon> eticketCoupons;

	/**
	 * 淘宝优惠券
	 */
	@ApiListField("inner_coupons")
	@ApiField("oto_taobao_coupon")
	private List<OtoTaobaoCoupon> innerCoupons;

	/**
	 * 外部商品数组
	 */
	@ApiListField("out_items")
	@ApiField("oto_out_item")
	private List<OtoOutItem> outItems;

	/**
	 * 支付通道数据
	 */
	@ApiListField("pay_channel_list")
	@ApiField("acquire_order_pay_channel")
	private List<AcquireOrderPayChannel> payChannelList;

	/**
	 * 外部商家专柜编码
	 */
	@ApiField("shop_code")
	private String shopCode;

	/**
	 * 收银员淘宝账号
	 */
	@ApiField("taobao_sales_id")
	private Long taobaoSalesId;


	public Long getBuyerId() {
		return this.buyerId;
	}
	public void setBuyerId(Long buyerId) {
		this.buyerId = buyerId;
	}

	public List<OtoTaobaoCoupon> getEticketCoupons() {
		return this.eticketCoupons;
	}
	public void setEticketCoupons(List<OtoTaobaoCoupon> eticketCoupons) {
		this.eticketCoupons = eticketCoupons;
	}

	public List<OtoTaobaoCoupon> getInnerCoupons() {
		return this.innerCoupons;
	}
	public void setInnerCoupons(List<OtoTaobaoCoupon> innerCoupons) {
		this.innerCoupons = innerCoupons;
	}

	public List<OtoOutItem> getOutItems() {
		return this.outItems;
	}
	public void setOutItems(List<OtoOutItem> outItems) {
		this.outItems = outItems;
	}

	public List<AcquireOrderPayChannel> getPayChannelList() {
		return this.payChannelList;
	}
	public void setPayChannelList(List<AcquireOrderPayChannel> payChannelList) {
		this.payChannelList = payChannelList;
	}

	public String getShopCode() {
		return this.shopCode;
	}
	public void setShopCode(String shopCode) {
		this.shopCode = shopCode;
	}

	public Long getTaobaoSalesId() {
		return this.taobaoSalesId;
	}
	public void setTaobaoSalesId(Long taobaoSalesId) {
		this.taobaoSalesId = taobaoSalesId;
	}

}
