package com.taobao.api.internal.util;

/**
 * 布尔变量常用操作
 */
public class BooleanUtils {
    private static final String FLAG_TRUE = "T";
    private static final String FLAG_FALSE = "F";

    /**
     * 客户端与tmc通信时无法序列化boolean变量
     * 因此通信前要先将boolean变量转成"T"/"F"这样的字符串形式
     * "T"/"F"比将boolean变量直接转成"true"/"false"这样的字符串形式更节省空间
     * 在网络传输时能节约带宽
     */
    public static String convertToFlag(boolean val) {
        return val ? FLAG_TRUE : FLAG_FALSE;
    }

    public static boolean convertFromFlag(String flag) {
        if(FLAG_TRUE.equals(flag)) {
            return true;
        } else if(FLAG_FALSE.equals(flag)) {
            return false;
        }
        throw new RuntimeException("boolean flag must be T or F, but found " + flag);
    }
}
