package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaAscpLogisticsIdentcodeQueryResponse;

/**
 * TOP API: alibaba.ascp.logistics.identcode.query request
 * 
 * @author top auto create
 * @since 1.0, 2023.11.01
 */
public class AlibabaAscpLogisticsIdentcodeQueryRequest extends BaseTaobaoRequest<AlibabaAscpLogisticsIdentcodeQueryResponse> {
	
	

	/** 
	* 是否可用
	 */
	private Boolean available;

	/** 
	* 品牌ID，"11119": "Lenovo联想",   "11656": "Asus华硕",   "11813": "Huawei华为",   "21660": "Hasee神舟",   "21999": "MSI微星",   "26683": "Dell戴尔",   "26691": "Acer宏碁",   "28247": "OPPO",   "30111": "Apple苹果",   "31140": "HP惠普",   "91621": "vivo",   "3506680": "MIUI小米",   "184048021": "ThinkPad",   "590022244": "honor荣耀",   "600184882": "OnePlus一加",   "616784001": "MACHENIKE",   "639188075": "THUNDEROBOT",   "775486237": "MECHREVO机械革命",   "1880225553": "ROG玩家国度",   "7051840193": "iQOO(数码)"
	 */
	private String brandId;

	/** 
	* 识别码列表
	 */
	private String identCodeList;

	/** 
	* 识别码类型，SN，IMEI
	 */
	private String identType;

	/** 
	* 根类目ID，"1101": "笔记本电脑",   "1512": "手机类目",   "50019780": "平板电脑"
	 */
	private String rootCatId;

	public void setAvailable(Boolean available) {
		this.available = available;
	}

	public Boolean getAvailable() {
		return this.available;
	}

	public void setBrandId(String brandId) {
		this.brandId = brandId;
	}

	public String getBrandId() {
		return this.brandId;
	}

	public void setIdentCodeList(String identCodeList) {
		this.identCodeList = identCodeList;
	}

	public String getIdentCodeList() {
		return this.identCodeList;
	}

	public void setIdentType(String identType) {
		this.identType = identType;
	}

	public String getIdentType() {
		return this.identType;
	}

	public void setRootCatId(String rootCatId) {
		this.rootCatId = rootCatId;
	}

	public String getRootCatId() {
		return this.rootCatId;
	}

	public String getApiMethodName() {
		return "alibaba.ascp.logistics.identcode.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("available", this.available);
		txtParams.put("brand_id", this.brandId);
		txtParams.put("ident_code_list", this.identCodeList);
		txtParams.put("ident_type", this.identType);
		txtParams.put("root_cat_id", this.rootCatId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaAscpLogisticsIdentcodeQueryResponse> getResponseClass() {
		return AlibabaAscpLogisticsIdentcodeQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(brandId, "brandId");
		RequestCheckUtils.checkNotEmpty(identCodeList, "identCodeList");
		RequestCheckUtils.checkNotEmpty(identType, "identType");
		RequestCheckUtils.checkNotEmpty(rootCatId, "rootCatId");
	}
	

}