package com.taobao.api.request;

import com.taobao.api.domain.PayChannelInput;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.OtoOrderPaychannelCalculateResponse;

/**
 * TOP API: taobao.oto.order.paychannel.calculate request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class OtoOrderPaychannelCalculateRequest extends BaseTaobaoRequest<OtoOrderPaychannelCalculateResponse> {
	
	

	/** 
	* 支付通道计算输入参数
	 */
	private String payChannelInput;

	public void setPayChannelInput(String payChannelInput) {
		this.payChannelInput = payChannelInput;
	}

	public void setPayChannelInput(PayChannelInput payChannelInput) {
		this.payChannelInput = new JSONWriter(false,true).write(payChannelInput);
	}

	public String getPayChannelInput() {
		return this.payChannelInput;
	}

	public String getApiMethodName() {
		return "taobao.oto.order.paychannel.calculate";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("pay_channel_input", this.payChannelInput);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OtoOrderPaychannelCalculateResponse> getResponseClass() {
		return OtoOrderPaychannelCalculateResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}