package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.OtoOrderQueryQrcodeResponse;

/**
 * TOP API: taobao.oto.order.query.qrcode request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class OtoOrderQueryQrcodeRequest extends BaseTaobaoRequest<OtoOrderQueryQrcodeResponse> {
	
	

	/** 
	* 二维码短链接
	 */
	private String shortUrl;

	public void setShortUrl(String shortUrl) {
		this.shortUrl = shortUrl;
	}

	public String getShortUrl() {
		return this.shortUrl;
	}

	public String getApiMethodName() {
		return "taobao.oto.order.query.qrcode";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("short_url", this.shortUrl);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OtoOrderQueryQrcodeResponse> getResponseClass() {
		return OtoOrderQueryQrcodeResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(shortUrl, "shortUrl");
	}
	

}