package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.RefundNegotiatereturnRenderResponse;

/**
 * TOP API: taobao.refund.negotiatereturn.render request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.24
 */
public class RefundNegotiatereturnRenderRequest extends BaseTaobaoRequest<RefundNegotiatereturnRenderResponse> {
	
	

	/** 
	* 退款编号
	 */
	private Long refundId;

	public void setRefundId(Long refundId) {
		this.refundId = refundId;
	}

	public Long getRefundId() {
		return this.refundId;
	}

	public String getApiMethodName() {
		return "taobao.refund.negotiatereturn.render";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("refund_id", this.refundId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<RefundNegotiatereturnRenderResponse> getResponseClass() {
		return RefundNegotiatereturnRenderResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(refundId, "refundId");
	}
	

}