package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.RefundNegotiatereturnResponse;

/**
 * TOP API: taobao.refund.negotiatereturn request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.24
 */
public class RefundNegotiatereturnRequest extends BaseTaobaoRequest<RefundNegotiatereturnResponse> {
	
	

	/** 
	* 地址ID，通过协商退货退款渲染接口获取到的
	 */
	private Long addressId;

	/** 
	* 退款金额，单位（分）
	 */
	private Long refundFee;

	/** 
	* 退款编号
	 */
	private Long refundId;

	/** 
	* 退款版本号
	 */
	private Long refundVersion;

	public void setAddressId(Long addressId) {
		this.addressId = addressId;
	}

	public Long getAddressId() {
		return this.addressId;
	}

	public void setRefundFee(Long refundFee) {
		this.refundFee = refundFee;
	}

	public Long getRefundFee() {
		return this.refundFee;
	}

	public void setRefundId(Long refundId) {
		this.refundId = refundId;
	}

	public Long getRefundId() {
		return this.refundId;
	}

	public void setRefundVersion(Long refundVersion) {
		this.refundVersion = refundVersion;
	}

	public Long getRefundVersion() {
		return this.refundVersion;
	}

	public String getApiMethodName() {
		return "taobao.refund.negotiatereturn";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("address_id", this.addressId);
		txtParams.put("refund_fee", this.refundFee);
		txtParams.put("refund_id", this.refundId);
		txtParams.put("refund_version", this.refundVersion);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<RefundNegotiatereturnResponse> getResponseClass() {
		return RefundNegotiatereturnResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(addressId, "addressId");
		RequestCheckUtils.checkNotEmpty(refundFee, "refundFee");
		RequestCheckUtils.checkNotEmpty(refundId, "refundId");
		RequestCheckUtils.checkNotEmpty(refundVersion, "refundVersion");
	}
	

}