package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.TmallItemCalculateHscodeGetResponse;

/**
 * TOP API: tmall.item.calculate.hscode.get request
 * 
 * @author top auto create
 * @since 1.0, 2021.11.23
 */
public class TmallItemCalculateHscodeGetRequest extends BaseTaobaoRequest<TmallItemCalculateHscodeGetResponse> {
	
	

	/** 
	* 商品id
	 */
	private Long itemId;

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public String getApiMethodName() {
		return "tmall.item.calculate.hscode.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("item_id", this.itemId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallItemCalculateHscodeGetResponse> getResponseClass() {
		return TmallItemCalculateHscodeGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}