package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TopSecretAppkeyBillDetailResponse;

/**
 * TOP API: taobao.top.secret.appkey.bill.detail request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.08
 */
public class TopSecretAppkeyBillDetailRequest extends BaseTaobaoRequest<TopSecretAppkeyBillDetailResponse> {
	
	

	/** 
	* 卖家账单查询
	 */
	private String appBillQueryRequest;

	public void setAppBillQueryRequest(String appBillQueryRequest) {
		this.appBillQueryRequest = appBillQueryRequest;
	}

	public void setAppBillQueryRequest(AppBillQueryRequest appBillQueryRequest) {
		this.appBillQueryRequest = new JSONWriter(false,true).write(appBillQueryRequest);
	}

	public String getAppBillQueryRequest() {
		return this.appBillQueryRequest;
	}

	public String getApiMethodName() {
		return "taobao.top.secret.appkey.bill.detail";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("app_bill_query_request", this.appBillQueryRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TopSecretAppkeyBillDetailResponse> getResponseClass() {
		return TopSecretAppkeyBillDetailResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 卖家账单查询
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class AppBillQueryRequest extends TaobaoObject {

	private static final long serialVersionUID = 5738936984571124355L;

	/**
		 * 账单时间
		 */
		@ApiField("biz_date")
		private Date bizDate;
		/**
		 * 页号，从1开始
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 页大小，不得超过1000
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Date getBizDate() {
			return this.bizDate;
		}
		public void setBizDate(Date bizDate) {
			this.bizDate = bizDate;
		}
		public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}


}