package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TopSecretExtendResponse;

/**
 * TOP API: taobao.top.secret.extend request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.04
 */
public class TopSecretExtendRequest extends BaseTaobaoRequest<TopSecretExtendResponse> {
	
	

	/** 
	* 虚拟号延期请求
	 */
	private String extendRequest;

	public void setExtendRequest(String extendRequest) {
		this.extendRequest = extendRequest;
	}

	public void setExtendRequest(SecretNoExtendRequest extendRequest) {
		this.extendRequest = new JSONWriter(false,true).write(extendRequest);
	}

	public String getExtendRequest() {
		return this.extendRequest;
	}

	public String getApiMethodName() {
		return "taobao.top.secret.extend";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("extend_request", this.extendRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TopSecretExtendResponse> getResponseClass() {
		return TopSecretExtendResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 虚拟号延期请求
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SecretNoExtendRequest extends TaobaoObject {

	private static final long serialVersionUID = 8663891724563439984L;

	/**
		 * 虚拟号有效期延长天数，发货场景只能填7、15、30
		 */
		@ApiField("extend_days")
		private Long extendDays;
		/**
		 * 收件人ID (Open Addressee ID)，长度在128个字符之内。
		 */
		@ApiField("oaid")
		private String oaid;
		/**
		 * 交易订单ID
		 */
		@ApiField("order_id")
		private Long orderId;
		/**
		 * 解密场景编号。不同场景，解密策略不同。请根据产品功能选择相应的场景编号。可选的场景：1001(顺丰电子面单发货)、1002(4通一达电子面单发货)、1003(EMS电子面单发货)、1004(其他电子面单发货)、1005(线下门店发货)、1006(手工单发货)、1007(代发货)、2001(客户售后服务)、2002(客户关怀)
		 */
		@ApiField("scene")
		private String scene;
	

	public Long getExtendDays() {
			return this.extendDays;
		}
		public void setExtendDays(Long extendDays) {
			this.extendDays = extendDays;
		}
		public String getOaid() {
			return this.oaid;
		}
		public void setOaid(String oaid) {
			this.oaid = oaid;
		}
		public Long getOrderId() {
			return this.orderId;
		}
		public void setOrderId(Long orderId) {
			this.orderId = orderId;
		}
		public String getScene() {
			return this.scene;
		}
		public void setScene(String scene) {
			this.scene = scene;
		}

}


}