package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TradesSoldQueryResponse;

/**
 * TOP API: taobao.trades.sold.query request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.19
 */
public class TradesSoldQueryRequest extends BaseTaobaoRequest<TradesSoldQueryResponse> {
	
	

	/** 
	* 订单类型，默认值为1，可选值为：交易(1)，分销(2)，换货(3)
	 */
	private String orderType;

	/** 
	* 查询条件列表，多个条件之间是OR关系，最多支持20个。receiver_name、receiver_mobile、receiver_phone至少有一个值不为空。
	 */
	private String queryList;

	/** 
	* 业务场景编码。不同场景，策略不同。请根据产品功能选择相应的场景编号。可选的场景：1001(客服咨询)、1002(售后服务)，<a href="https:open.taobao.comdoc.htm?docId=120186&docType=1" target="_blank">详情点击<a>
	 */
	private String scene;

	public void setOrderType(String orderType) {
		this.orderType = orderType;
	}

	public String getOrderType() {
		return this.orderType;
	}

	public void setQueryList(String queryList) {
		this.queryList = queryList;
	}

	public void setQueryList(List<OrderQuery> queryList) {
		this.queryList = new JSONWriter(false,true).write(queryList);
	}

	public String getQueryList() {
		return this.queryList;
	}

	public void setScene(String scene) {
		this.scene = scene;
	}

	public String getScene() {
		return this.scene;
	}

	public String getApiMethodName() {
		return "taobao.trades.sold.query";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("order_type", this.orderType);
		txtParams.put("query_list", this.queryList);
		txtParams.put("scene", this.scene);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TradesSoldQueryResponse> getResponseClass() {
		return TradesSoldQueryResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(queryList, 999, "queryList");
	}
	
	/**
 * 查询条件列表，多个条件之间是OR关系，最多支持20个。receiver_name、receiver_mobile、receiver_phone至少有一个值不为空。
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class OrderQuery extends TaobaoObject {

	private static final long serialVersionUID = 2696416855762568265L;

	/**
		 * 查询三个月内交易创建时间开始。格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("end_created")
		private Date endCreated;
		/**
		 * 收件人的手机号
		 */
		@ApiField("receiver_mobile")
		private String receiverMobile;
		/**
		 * 收件人的姓名
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 收件人电话号码
		 */
		@ApiField("receiver_phone")
		private String receiverPhone;
		/**
		 * 查询交易创建时间结束。格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("start_created")
		private Date startCreated;
	

	public Date getEndCreated() {
			return this.endCreated;
		}
		public void setEndCreated(Date endCreated) {
			this.endCreated = endCreated;
		}
		public String getReceiverMobile() {
			return this.receiverMobile;
		}
		public void setReceiverMobile(String receiverMobile) {
			this.receiverMobile = receiverMobile;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public String getReceiverPhone() {
			return this.receiverPhone;
		}
		public void setReceiverPhone(String receiverPhone) {
			this.receiverPhone = receiverPhone;
		}
		public Date getStartCreated() {
			return this.startCreated;
		}
		public void setStartCreated(Date startCreated) {
			this.startCreated = startCreated;
		}

}


}