package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.UserOpenuidGetbynickResponse;

/**
 * TOP API: taobao.user.openuid.getbynick request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.09
 */
public class UserOpenuidGetbynickRequest extends BaseTaobaoRequest<UserOpenuidGetbynickResponse> {
	
	

	/** 
	* 买家nick列表
	 */
	private String buyerNicks;

	public void setBuyerNicks(String buyerNicks) {
		this.buyerNicks = buyerNicks;
	}

	public String getBuyerNicks() {
		return this.buyerNicks;
	}

	public String getApiMethodName() {
		return "taobao.user.openuid.getbynick";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("buyer_nicks", this.buyerNicks);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UserOpenuidGetbynickResponse> getResponseClass() {
		return UserOpenuidGetbynickResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(buyerNicks, "buyerNicks");
	}
	

}