package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.top.secret.appkey.bill.detail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TopSecretAppkeyBillDetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 8879891697469998322L;

	/** 
	 * 账单明细
	 */
	@ApiListField("data")
	@ApiField("bill_detail_info")
	private List<BillDetailInfo> data;

	/** 
	 * 账单总个数
	 */
	@ApiField("total_num")
	private Long totalNum;


	public void setData(List<BillDetailInfo> data) {
		this.data = data;
	}
	public List<BillDetailInfo> getData( ) {
		return this.data;
	}

	public void setTotalNum(Long totalNum) {
		this.totalNum = totalNum;
	}
	public Long getTotalNum( ) {
		return this.totalNum;
	}
	
	/**
 * 账单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BillDetailInfo extends TaobaoObject {

	private static final long serialVersionUID = 5273715354975354448L;

	/**
		 * 账单持续时间，号租费时单位为天，通话费单位为分钟
		 */
		@ApiField("bill_duration")
		private Long billDuration;
		/**
		 * 0-号租费，1-通话费
		 */
		@ApiField("bill_item")
		private Long billItem;
		/**
		 * 账单计费
		 */
		@ApiField("cost")
		private String cost;
		/**
		 * 已弃用,查询账单详情请使用taobao.top.secret.bill.detail接口。
		 */
		@ApiField("end")
		private Date end;
		/**
		 * 已弃用,查询账单详情请使用taobao.top.secret.bill.detail接口。
		 */
		@ApiField("secret_no")
		private String secretNo;
		/**
		 * 商家昵称
		 */
		@ApiField("seller_nick")
		private String sellerNick;
		/**
		 * 店铺名称
		 */
		@ApiField("shop_nick")
		private String shopNick;
		/**
		 * 已弃用,查询账单详情请使用taobao.top.secret.bill.detail接口。
		 */
		@ApiField("start")
		private Date start;
	

	public Long getBillDuration() {
			return this.billDuration;
		}
		public void setBillDuration(Long billDuration) {
			this.billDuration = billDuration;
		}
		public Long getBillItem() {
			return this.billItem;
		}
		public void setBillItem(Long billItem) {
			this.billItem = billItem;
		}
		public String getCost() {
			return this.cost;
		}
		public void setCost(String cost) {
			this.cost = cost;
		}
		public Date getEnd() {
			return this.end;
		}
		public void setEnd(Date end) {
			this.end = end;
		}
		public String getSecretNo() {
			return this.secretNo;
		}
		public void setSecretNo(String secretNo) {
			this.secretNo = secretNo;
		}
		public String getSellerNick() {
			return this.sellerNick;
		}
		public void setSellerNick(String sellerNick) {
			this.sellerNick = sellerNick;
		}
		public String getShopNick() {
			return this.shopNick;
		}
		public void setShopNick(String shopNick) {
			this.shopNick = shopNick;
		}
		public Date getStart() {
			return this.start;
		}
		public void setStart(Date start) {
			this.start = start;
		}

}



}
