/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.api.internal.util;

import com.taobao.api.internal.util.StringUtils;
import com.taobao.api.internal.util.TaobaoUtils;
import com.taobao.api.internal.util.WebUtils;
import java.io.IOException;
import java.util.Date;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TaobaoLogger {
    private static final Log log = LogFactory.getLog((String)"topsdk");
    private static final String LOG_SPLIT = "^_^";
    private static String osName = System.getProperties().getProperty("os.name");
    private static boolean needEnableLogger = true;

    public static void setNeedEnableLogger(boolean needEnableLogger) {
        TaobaoLogger.needEnableLogger = needEnableLogger;
    }

    public static void logApiError(String appKey, String apiName, String url, Map<String, String> params, long latency, String errorMessage) {
        if (!needEnableLogger) {
            return;
        }
        StringBuilder sb = new StringBuilder();
        sb.append(TaobaoLogger.formatDateTime(new Date()));
        sb.append(LOG_SPLIT);
        sb.append(appKey);
        sb.append(LOG_SPLIT);
        sb.append(apiName);
        sb.append(LOG_SPLIT);
        sb.append(TaobaoUtils.getIntranetIp());
        sb.append(LOG_SPLIT);
        sb.append(osName);
        sb.append(LOG_SPLIT);
        sb.append(latency);
        sb.append(LOG_SPLIT);
        sb.append(url);
        try {
            sb.append(LOG_SPLIT);
            sb.append(WebUtils.buildQuery(params, "utf-8"));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        sb.append(LOG_SPLIT);
        sb.append(errorMessage);
        try {
            sb.append(LOG_SPLIT);
            sb.append(WebUtils.getTopGwIp(url));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        log.error((Object)sb.toString());
    }

    private static String formatDateTime(Date date) {
        return StringUtils.formatDateTime(date, "yyyy-MM-dd HH:mm:ss.SSS");
    }
}

