/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao;

import com.taobao.api.ApiException;
import com.taobao.api.DefaultTaobaoClient;
import com.taobao.api.TaobaoClient;
import com.taobao.api.TaobaoRequest;
import com.taobao.api.domain.Refund;
import com.taobao.api.request.RefundGetRequest;
import com.taobao.api.request.RefundsReceiveGetRequest;
import com.taobao.api.response.RefundGetResponse;
import com.taobao.api.response.RefundsReceiveGetResponse;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import tech.qihangec.open.tao.common.ApiResultVo;
import tech.qihangec.open.tao.common.ApiResultVoEnum;
import tech.qihangec.open.tao.domain.TaoRefund;

public class RefundApiHelper {
    private static Logger log = LoggerFactory.getLogger(RefundApiHelper.class);
    private static final String REFUND_FIELDS = "refund_id, tid, title, buyer_nick, seller_nick, total_fee, status, created,num, refund_fee, oid, good_status, company_name, sid, payment, reason, desc, has_good_return, modified, order_status,refund_phase,dispute_type,end_time,sku,combineItemInfo,sku_info,skuInfo,combine_item_info";

    public static ApiResultVo<TaoRefund> pullRefund(LocalDateTime startTime, LocalDateTime endTime, String url, String appKey, String appSecret, String sessionKey) throws ApiException {
        Refund detail;
        TaoRefund refund;
        DefaultTaobaoClient client = new DefaultTaobaoClient(url, appKey, appSecret);
        ArrayList<TaoRefund> list = new ArrayList<TaoRefund>();
        Long pageNo = 1L;
        Long pageSize = 100L;
        RefundsReceiveGetRequest req = new RefundsReceiveGetRequest();
        req.setFields(REFUND_FIELDS);
        req.setStartModified(Date.from(startTime.toInstant(ZoneOffset.UTC)));
        req.setEndModified(Date.from(endTime.toInstant(ZoneOffset.UTC)));
        req.setUseHasNext(Boolean.valueOf(true));
        req.setPageNo(pageNo);
        req.setPageSize(pageSize);
        RefundsReceiveGetResponse rsp = (RefundsReceiveGetResponse)client.execute((TaobaoRequest)req, sessionKey);
        if (rsp.getRefunds() == null) {
            if (!StringUtils.isEmpty(rsp.getErrorCode())) {
                return ApiResultVo.error(500, "\u63a5\u53e3\u8c03\u7528\u9519\u8bef\uff1a" + rsp.getMsg() + rsp.getSubMsg());
            }
            log.info("========\u589e\u91cf\u62c9\u53d6\u9000\u6b3e\uff1a\u65e0\u9000\u6b3e,{}==========", (Object)LocalDateTime.now());
            return ApiResultVo.success(0, new ArrayList());
        }
        for (Refund item : rsp.getRefunds()) {
            refund = RefundApiHelper.assembleRefund(item);
            detail = RefundApiHelper.pullRefundDetail((TaobaoClient)client, sessionKey, Long.parseLong(item.getRefundId()));
            if (detail != null) {
                refund.setDisputeType(detail.getDisputeType());
                refund.setNumIid(detail.getNumIid());
                refund.setNum(detail.getNum());
            }
            list.add(refund);
        }
        while (rsp.getHasNext().booleanValue()) {
            Iterator iterator = pageNo;
            pageNo = pageNo + 1L;
            req.setPageNo(pageNo);
            rsp = (RefundsReceiveGetResponse)client.execute((TaobaoRequest)req, sessionKey);
            for (Refund item : rsp.getRefunds()) {
                refund = RefundApiHelper.assembleRefund(item);
                detail = RefundApiHelper.pullRefundDetail((TaobaoClient)client, sessionKey, Long.parseLong(item.getRefundId()));
                if (detail != null) {
                    refund.setDisputeType(detail.getDisputeType());
                    refund.setNumIid(detail.getNumIid());
                    refund.setNum(detail.getNum());
                }
                list.add(refund);
            }
        }
        return ApiResultVo.success(list.size(), list);
    }

    public static ApiResultVo<TaoRefund> pullRefundDetail(Long refundId, String url, String appKey, String appSecret, String sessionKey) throws ApiException {
        DefaultTaobaoClient client = new DefaultTaobaoClient(url, appKey, appSecret);
        Refund detail = RefundApiHelper.pullRefundDetail((TaobaoClient)client, sessionKey, refundId);
        if (detail != null) {
            TaoRefund refund = RefundApiHelper.assembleRefund(detail);
            refund.setDisputeType(detail.getDisputeType());
            refund.setNumIid(detail.getNumIid());
            refund.setNum(detail.getNum());
            return ApiResultVo.success(refund);
        }
        return ApiResultVo.error(ApiResultVoEnum.SystemException, "\u6ca1\u6709\u627e\u5230\u9000\u6b3e\u6570\u636e");
    }

    private static Refund pullRefundDetail(TaobaoClient client, String sessionKey, Long refundId) {
        try {
            RefundGetRequest req1 = new RefundGetRequest();
            String fields = "refund_id, alipay_no, tid, oid, buyer_nick, seller_nick, total_fee, status, created, refund_fee, good_status, has_good_return, payment, reason, desc, num_iid, title, price, num, good_return_time, company_name, sid, address, shipping_type, refund_remind_timeout, refund_phase, refund_version, operation_contraint, attribute, outer_id,dispute_type,sku,end_time";
            req1.setFields(fields);
            req1.setRefundId(refundId);
            RefundGetResponse rsp1 = (RefundGetResponse)client.execute((TaobaoRequest)req1, sessionKey);
            return rsp1.getRefund();
        }
        catch (ApiException e) {
            return null;
        }
    }

    private static TaoRefund assembleRefund(Refund item) {
        TaoRefund refund = new TaoRefund();
        refund.setRefundId(item.getRefundId());
        refund.setTid(item.getTid());
        refund.setOid(item.getOid());
        refund.setSellerNick(item.getSellerNick());
        refund.setPayment(StringUtils.isEmpty(item.getPayment()) ? 0.0 : Double.parseDouble(item.getPayment()));
        refund.setTotalFee(Double.parseDouble(item.getTotalFee()));
        refund.setRefundFee(Double.parseDouble(item.getRefundFee()));
        refund.setCreated(item.getCreated());
        refund.setStatus(item.getStatus());
        refund.setTitle(item.getTitle());
        refund.setDesc1(item.getDesc());
        refund.setBuyerNick(item.getBuyerNick());
        refund.setBuyerOpenUid(item.getBuyerOpenUid());
        refund.setGoodStatus(item.getGoodStatus());
        refund.setHasGoodReturn(item.getHasGoodReturn() == true ? 1 : 0);
        refund.setOrderStatus(item.getOrderStatus());
        refund.setModified(item.getModified());
        refund.setReason(item.getReason());
        refund.setNum(item.getNum());
        refund.setRefundPhase(item.getRefundPhase());
        refund.setSid(item.getSid());
        refund.setSku(item.getSku());
        return refund;
    }
}

