/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao;

import java.time.LocalDateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import tech.qihangec.open.tao.OrderApiHelper;
import tech.qihangec.open.tao.common.ApiResultVo;
import tech.qihangec.open.tao.common.ApiResultVoEnum;
import tech.qihangec.open.tao.domain.TaoOrder;
import tech.qihangec.open.tao.service.TaoOrderService;

@Service
public class TaoOrderApiService {
    private static Logger log = LoggerFactory.getLogger(TaoOrderApiService.class);
    private final TaoOrderService orderService;

    public ApiResultVo<TaoOrder> pullOrderList(LocalDateTime startTime, LocalDateTime endTime, Integer shopId, String serverUrl, String appKey, String appSecret, String sessionKey) {
        Long pageSize = 100L;
        Long pageIndex = 1L;
        try {
            ApiResultVo<TaoOrder> upResult = OrderApiHelper.pullIncrementOrder(startTime, endTime, pageIndex, pageSize, serverUrl, appKey, appSecret, sessionKey);
            if (upResult.getCode() == ApiResultVoEnum.SUCCESS.getIndex()) {
                log.info("\u83b7\u53d6\u8ba2\u5355List\u6210\u529f============");
                int insertSuccess = 0;
                int totalError = 0;
                int hasExistOrder = 0;
                for (TaoOrder order : upResult.getList()) {
                    log.info("\u5f00\u59cb\u63d2\u5165\u8ba2\u5355============" + order.getTid());
                    ApiResultVo<Integer> result = this.orderService.saveOrder(shopId, order);
                    log.info("\u5f00\u59cb\u63d2\u5165\u8ba2\u5355\u8fd4\u56de============" + result.getCode());
                    if (result.getCode() == ApiResultVoEnum.DataExist.getIndex()) {
                        ++hasExistOrder;
                        continue;
                    }
                    if (result.getCode() == ApiResultVoEnum.SUCCESS.getIndex()) {
                        ++insertSuccess;
                        continue;
                    }
                    ++totalError;
                }
                String msg = "\u6210\u529f\uff0c\u603b\u5171\u627e\u5230\uff1a" + upResult.getTotalRecords() + "\u6761\u8ba2\u5355\uff0c\u65b0\u589e\uff1a" + insertSuccess + "\u6761\uff0c\u6dfb\u52a0\u9519\u8bef\uff1a" + totalError + "\u6761\uff0c\u66f4\u65b0\uff1a" + hasExistOrder + "\u6761";
                log.info("Tao\u8ba2\u5355\u63a5\u53e3\u62c9\u53d6\u7ed3\u679c\uff1a" + msg);
            } else {
                String errorMsg = "";
                errorMsg = upResult.getCode() == 401 ? "Token\u5df2\u8fc7\u671f\uff0c\u8bf7\u91cd\u65b0\u6388\u6743" : upResult.getMsg();
                log.info("====\u83b7\u53d6\u8ba2\u5355\u5931\u8d25=====" + errorMsg);
            }
            return upResult;
        }
        catch (Exception e) {
            log.info("====\u83b7\u53d6\u8ba2\u5355\u5f02\u5e38=====" + e.getMessage());
            e.printStackTrace();
            return ApiResultVo.error(ApiResultVoEnum.ApiException, "\u83b7\u53d6\u8ba2\u5355\u5f02\u5e38" + e.getMessage());
        }
    }

    public ApiResultVo<TaoOrder> pullOrderDetail(Integer shopId, Long tid, String serverUrl, String appKey, String appSecret, String sessionKey) {
        try {
            ApiResultVo<TaoOrder> resultVo = OrderApiHelper.pullOrderDetail(tid, serverUrl, appKey, appSecret, sessionKey);
            ApiResultVo<Integer> result = this.orderService.saveOrder(shopId, resultVo.getData());
            if (result.getCode() == ApiResultVoEnum.DataExist.getIndex()) {
                log.info("/**************\u4e3b\u52a8\u66f4\u65b0tao\u8ba2\u5355\uff1a\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u5e93\uff1a" + resultVo.getData().getId() + "\u5b58\u5728\u3001\u66f4\u65b0****************/");
            } else if (result.getCode() == ApiResultVoEnum.SUCCESS.getIndex()) {
                log.info("/**************\u4e3b\u52a8\u66f4\u65b0tao\u8ba2\u5355\uff1a\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u5e93\uff1a" + resultVo.getData().getId() + "\u4e0d\u5b58\u5728\u3001\u65b0\u589e****************/");
            }
            return resultVo;
        }
        catch (Exception e) {
            log.info("====\u83b7\u53d6\u8ba2\u5355\u5f02\u5e38=====" + e.getMessage());
            e.printStackTrace();
            return ApiResultVo.error(ApiResultVoEnum.ApiException, "\u83b7\u53d6\u8ba2\u5355\u5f02\u5e38" + e.getMessage());
        }
    }

    public TaoOrderApiService(TaoOrderService orderService) {
        this.orderService = orderService;
    }
}

