/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao;

import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.logging.Logger;
import org.springframework.stereotype.Service;
import tech.qihangec.open.tao.RefundApiHelper;
import tech.qihangec.open.tao.common.ApiResultVo;
import tech.qihangec.open.tao.common.ApiResultVoEnum;
import tech.qihangec.open.tao.domain.TaoRefund;
import tech.qihangec.open.tao.service.TaoRefundService;

@Service
public class TaoRefundApiService {
    private static final Logger log = Logger.getLogger(TaoRefundApiService.class.getName());
    private final TaoRefundService refundService;

    public ApiResultVo<TaoRefund> pullRefundList(LocalDateTime startTime, LocalDateTime endTime, Integer shopId, String serverUrl, String appKey, String appSecret, String sessionKey) {
        log.info("/**************\u4e3b\u52a8\u66f4\u65b0tao\u9000\u8d27\u8ba2\u5355****************/");
        Date currDateTime = new Date();
        long beginTime = System.currentTimeMillis();
        ArrayList<TaoRefund> list = new ArrayList<TaoRefund>();
        try {
            ApiResultVo<TaoRefund> upResult = RefundApiHelper.pullRefund(startTime, endTime, serverUrl, appKey, appSecret, sessionKey);
            if (upResult.getCode() != 0) {
                log.info("/**************\u4e3b\u52a8\u66f4\u65b0tao\u9000\u8d27\u8ba2\u5355\uff1a\u7b2c\u4e00\u6b21\u83b7\u53d6\u7ed3\u679c\u5931\u8d25\uff1a" + upResult.getMsg() + "****************/");
                return ApiResultVo.error(ApiResultVoEnum.ApiException.getIndex(), upResult.getMsg());
            }
            log.info("/**************\u4e3b\u52a8\u66f4\u65b0tao\u9000\u8d27\u8ba2\u5355\uff1a\u7b2c\u4e00\u6b21\u83b7\u53d6\u7ed3\u679c\uff1a\u603b\u8bb0\u5f55\u6570" + upResult.getTotalRecords() + "****************/");
            int insertSuccess = 0;
            int totalError = 0;
            int hasExistOrder = 0;
            for (TaoRefund refund : upResult.getList()) {
                int result = this.refundService.saveAndUpdateRefund(shopId, refund);
                if (result == ApiResultVoEnum.DataExist.getIndex()) {
                    list.add(refund);
                    log.info("/**************\u4e3b\u52a8\u66f4\u65b0tao\u9000\u8d27\u8ba2\u5355\uff1a\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u5e93\uff1a" + refund.getRefundId() + "\u5b58\u5728\u3001\u66f4\u65b0****************/");
                    ++hasExistOrder;
                    continue;
                }
                if (result == ApiResultVoEnum.SUCCESS.getIndex()) {
                    log.info("/**************\u4e3b\u52a8\u66f4\u65b0tao\u9000\u8d27\u8ba2\u5355\uff1a\u5f00\u59cb\u63d2\u5165\u6570\u636e\u5e93\uff1a" + refund.getRefundId() + "\u4e0d\u5b58\u5728\u3001\u65b0\u589e****************/");
                    list.add(refund);
                    ++insertSuccess;
                    continue;
                }
                log.info("/**************\u4e3b\u52a8\u66f4\u65b0tao\u9000\u8d27\u8ba2\u5355\uff1a\u5f00\u59cb\u66f4\u65b0\u6570\u636e\u5e93\uff1a" + refund.getRefundId() + "\u62a5\u9519****************/");
                ++totalError;
            }
            log.info("/**************\u4e3b\u52a8\u66f4\u65b0tao\u8ba2\u5355\uff1aEND\uff1a****************/");
            return ApiResultVo.success(list.size(), list);
        }
        catch (Exception e) {
            return ApiResultVo.error(ApiResultVoEnum.ApiException, e.getMessage());
        }
    }

    public TaoRefundApiService(TaoRefundService refundService) {
        this.refundService = refundService;
    }
}

