/*
 * Decompiled with CFR 0.152.
 */
package tech.qihangec.open.tao.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.Date;
import java.util.List;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import tech.qihangec.open.tao.common.ApiResultVoEnum;
import tech.qihangec.open.tao.common.PageQuery;
import tech.qihangec.open.tao.common.PageResult;
import tech.qihangec.open.tao.domain.TaoRefund;
import tech.qihangec.open.tao.mapper.TaoRefundMapper;
import tech.qihangec.open.tao.service.TaoRefundService;

@Service
public class TaoRefundServiceImpl
extends ServiceImpl<TaoRefundMapper, TaoRefund>
implements TaoRefundService {
    private final TaoRefundMapper mapper;

    @Override
    public PageResult<TaoRefund> queryPageList(TaoRefund bo, PageQuery pageQuery) throws Exception {
        LambdaQueryWrapper queryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(bo.getShopId() != null, TaoRefund::getShopId, (Object)bo.getShopId())).eq(StringUtils.hasText((String)bo.getRefundId()), TaoRefund::getRefundId, (Object)bo.getRefundId())).eq(bo.getTid() != null, TaoRefund::getTid, (Object)bo.getTid());
        Page page = (Page)this.mapper.selectPage((IPage)pageQuery.build(), (Wrapper)queryWrapper);
        return PageResult.build(page);
    }

    @Override
    public int saveAndUpdateRefund(Integer shopId, TaoRefund refund) {
        List taoRefunds = this.mapper.selectList((Wrapper)new LambdaQueryWrapper().eq(TaoRefund::getRefundId, (Object)refund.getRefundId()));
        if (taoRefunds != null && taoRefunds.size() > 0) {
            TaoRefund update = new TaoRefund();
            update.setId(((TaoRefund)taoRefunds.get(0)).getId());
            update.setTid(refund.getTid());
            update.setOid(refund.getOid());
            update.setModified(refund.getModified());
            update.setStatus(refund.getStatus());
            update.setEndTime(refund.getEndTime());
            update.setUpdateTime(new Date());
            this.mapper.updateById(update);
            return ApiResultVoEnum.DataExist.getIndex();
        }
        refund.setShopId(shopId);
        refund.setCreateTime(new Date());
        this.mapper.insert(refund);
        return ApiResultVoEnum.SUCCESS.getIndex();
    }

    public TaoRefundServiceImpl(TaoRefundMapper mapper) {
        this.mapper = mapper;
    }
}

