package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtPurchasePurchasereturnCreateorderResponse;

/**
 * TOP API(QimenCloud): wdt.purchase.purchasereturn.createorder request
 * 
 * @author top auto create
 * @since 1.0, 2023.02.02
 */
public class WdtPurchasePurchasereturnCreateorderRequest extends BaseTaobaoRequest<WdtPurchasePurchasereturnCreateorderResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 采购退货单明细信息
	 */
	private String detailList;

	/** 
	* 是否审核
	 */
	private Boolean isCheck;

	/** 
	* 采购退货单单据信息
	 */
	private String orderInfo;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setDetailList(String detailList) {
		this.detailList = detailList;
	}

	public void setDetailList(List<DetailList> detailList) {
		this.detailList = new JSONWriter(false,false,true).write(detailList);
	}

	public String getDetailList() {
		return this.detailList;
	}

	public void setIsCheck(Boolean isCheck) {
		this.isCheck = isCheck;
	}

	public Boolean getIsCheck() {
		return this.isCheck;
	}

	public void setOrderInfo(String orderInfo) {
		this.orderInfo = orderInfo;
	}

	public void setOrderInfo(OrderInfo orderInfo) {
		this.orderInfo = new JSONWriter(false,false,true).write(orderInfo);
	}

	public String getOrderInfo() {
		return this.orderInfo;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.purchase.purchasereturn.createorder";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("detailList", this.detailList);
		txtParams.put("is_check", this.isCheck);
		txtParams.put("orderInfo", this.orderInfo);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtPurchasePurchasereturnCreateorderResponse> getResponseClass() {
		return WdtPurchasePurchasereturnCreateorderResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(detailList, 999999, "detailList");
     }
     
	/**
 * 采购退货单单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class OrderInfo {

	/**
		 * 联系人
		 */
		@ApiField("contact")
		private String contact;
		/**
		 * 系统内维护的物流公司编号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 其他费用
		 */
		@ApiField("other_fee")
		private String otherFee;
		/**
		 * 外部单号
		 */
		@ApiField("outer_no")
		private String outerNo;
		/**
		 * 邮费
		 */
		@ApiField("post_fee")
		private String postFee;
		/**
		 * 供应商编号
		 */
		@ApiField("provider_no")
		private String providerNo;
		/**
		 * 收件地址
		 */
		@ApiField("receive_address")
		private String receiveAddress;
		/**
		 * 市编码
		 */
		@ApiField("receive_city")
		private String receiveCity;
		/**
		 * 区编码
		 */
		@ApiField("receive_district")
		private String receiveDistrict;
		/**
		 * 省编码
		 */
		@ApiField("receive_province")
		private String receiveProvince;
		/**
		 * 引用的采购单号
		 */
		@ApiListField("ref_purchase_nos")
		@ApiField("string")
		private List<String> refPurchaseNos;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 联系电话
		 */
		@ApiField("telno")
		private String telno;
		/**
		 * 仓库编码
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getContact() {
			return this.contact;
		}
		public void setContact(String contact) {
			this.contact = contact;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getOtherFee() {
			return this.otherFee;
		}
		public void setOtherFee(String otherFee) {
			this.otherFee = otherFee;
		}
		public String getOuterNo() {
			return this.outerNo;
		}
		public void setOuterNo(String outerNo) {
			this.outerNo = outerNo;
		}
		public String getPostFee() {
			return this.postFee;
		}
		public void setPostFee(String postFee) {
			this.postFee = postFee;
		}
		public String getProviderNo() {
			return this.providerNo;
		}
		public void setProviderNo(String providerNo) {
			this.providerNo = providerNo;
		}
		public String getReceiveAddress() {
			return this.receiveAddress;
		}
		public void setReceiveAddress(String receiveAddress) {
			this.receiveAddress = receiveAddress;
		}
		public String getReceiveCity() {
			return this.receiveCity;
		}
		public void setReceiveCity(String receiveCity) {
			this.receiveCity = receiveCity;
		}
		public String getReceiveDistrict() {
			return this.receiveDistrict;
		}
		public void setReceiveDistrict(String receiveDistrict) {
			this.receiveDistrict = receiveDistrict;
		}
		public String getReceiveProvince() {
			return this.receiveProvince;
		}
		public void setReceiveProvince(String receiveProvince) {
			this.receiveProvince = receiveProvince;
		}
		public List<String> getRefPurchaseNos() {
			return this.refPurchaseNos;
		}
		public void setRefPurchaseNos(List<String> refPurchaseNos) {
			this.refPurchaseNos = refPurchaseNos;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getTelno() {
			return this.telno;
		}
		public void setTelno(String telno) {
			this.telno = telno;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 采购退货单明细信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("detailList")
public static class DetailList {

	/**
		 * 是否残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 折扣
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 退货数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 金额
		 */
		@ApiField("price")
		private String price;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 税率
		 */
		@ApiField("tax_rate")
		private String taxRate;
		/**
		 * 基本单位
		 */
		@ApiField("unit_name")
		private String unitName;
	

	public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}

}



}