package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtSalesTradequeryQuerywithdetailResponse;

/**
 * TOP API(QimenCloud): wdt.sales.tradequery.querywithdetail request
 * 
 * @author top auto create
 * @since 1.0, 2023.05.19
 */
public class WdtSalesTradequeryQuerywithdetailRequest extends BaseTaobaoRequest<WdtSalesTradequeryQuerywithdetailResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.sales.tradequery.querywithdetail";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtSalesTradequeryQuerywithdetailResponse> getResponseClass() {
		return WdtSalesTradequeryQuerywithdetailResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 是否计算分摊邮费
		 */
		@ApiField("cal_share_post_amount")
		private Boolean calSharePostAmount;
		/**
		 * 结束时间 修改结束时间，上同开始时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 是否使用从库查询
		 */
		@ApiField("is_slave")
		private Boolean isSlave;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_no")
		private String shopNo;
		/**
		 * 原始单号
		 */
		@ApiField("src_tid")
		private String srcTid;
		/**
		 * 开始时间 修改起始时间，若无订单号，则为必填。
		 */
		@ApiField("start_time")
		private String startTime;
		/**
		 * 订单状态 若多个状态则以“，”隔开。 订单状态:   4 线下退款 5已取消  6 待确认订单, 导入放入这个状态  待转预订单(待审核) 7待确认订单,导入时先放到这个状态（此状态不占用库存,可删除,离开这个状态就不能删除了) 10待付款  15等未付 16延时审核  19预订单前处理  20前处理(赠品，合并，拆分) 21委外前处理  23 异常预订单 24 换货预订单 26 待激活预订单 27待分配预订单  30待客审  35待财审  55已确认  95已发货  96 待录入计划成本，订单结算时有货品无计划成本 99 待过账 100已签收  101 已过账 105部分打款  110已完成
		 */
		@ApiField("status")
		private String status;
		/**
		 * 订单来源
		 */
		@ApiField("trade_from")
		private String tradeFrom;
		/**
		 * 订单编号
		 */
		@ApiField("trade_no")
		private String tradeNo;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public Boolean getCalSharePostAmount() {
			return this.calSharePostAmount;
		}
		public void setCalSharePostAmount(Boolean calSharePostAmount) {
			this.calSharePostAmount = calSharePostAmount;
		}
		public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public Boolean getIsSlave() {
			return this.isSlave;
		}
		public void setIsSlave(Boolean isSlave) {
			this.isSlave = isSlave;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getShopNo() {
			return this.shopNo;
		}
		public void setShopNo(String shopNo) {
			this.shopNo = shopNo;
		}
		public String getSrcTid() {
			return this.srcTid;
		}
		public void setSrcTid(String srcTid) {
			this.srcTid = srcTid;
		}
		public String getStartTime() {
			return this.startTime;
		}
		public void setStartTime(String startTime) {
			this.startTime = startTime;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getTradeFrom() {
			return this.tradeFrom;
		}
		public void setTradeFrom(String tradeFrom) {
			this.tradeFrom = tradeFrom;
		}
		public String getTradeNo() {
			return this.tradeNo;
		}
		public void setTradeNo(String tradeNo) {
			this.tradeNo = tradeNo;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 分页
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号从0开始
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}



}