package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtSettingPurchaseproviderPushResponse;

/**
 * TOP API(QimenCloud): wdt.setting.purchaseprovider.push request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.30
 */
public class WdtSettingPurchaseproviderPushRequest extends BaseTaobaoRequest<WdtSettingPurchaseproviderPushResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 供应商
	 */
	private String provider;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setProvider(String provider) {
		this.provider = provider;
	}

	public void setProvider(Provider provider) {
		this.provider = new JSONWriter(false,false,true).write(provider);
	}

	public String getProvider() {
		return this.provider;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.setting.purchaseprovider.push";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("provider", this.provider);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtSettingPurchaseproviderPushResponse> getResponseClass() {
		return WdtSettingPurchaseproviderPushResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 供应商
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Provider {

	/**
		 * 收款银行
		 */
		@ApiField("account_bank")
		private String accountBank;
		/**
		 * 银行账号
		 */
		@ApiField("account_bank_no")
		private String accountBankNo;
		/**
		 * 地址
		 */
		@ApiField("address")
		private String address;
		/**
		 * 到货周期
		 */
		@ApiField("arrive_cycle_days")
		private Long arriveCycleDays;
		/**
		 * 城市id
		 */
		@ApiField("city")
		private String city;
		/**
		 * 收款人
		 */
		@ApiField("collect_name")
		private String collectName;
		/**
		 * 联系人
		 */
		@ApiField("contact")
		private String contact;
		/**
		 * 地区id
		 */
		@ApiField("district")
		private String district;
		/**
		 * 邮箱
		 */
		@ApiField("email")
		private String email;
		/**
		 * 传真
		 */
		@ApiField("fax")
		private String fax;
		/**
		 * 是否禁用是否禁用  0:否 1:是 默认为0
		 */
		@ApiField("is_disabled")
		private Long isDisabled;
		/**
		 * 移动电话
		 */
		@ApiField("mobile")
		private String mobile;
		/**
		 * 供应商名称 provider_name
		 */
		@ApiField("provider_name")
		private String providerName;
		/**
		 * 供应商编号
		 */
		@ApiField("provider_no")
		private String providerNo;
		/**
		 * 省份id
		 */
		@ApiField("province")
		private String province;
		/**
		 * QQ
		 */
		@ApiField("qq")
		private String qq;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 座机
		 */
		@ApiField("telno")
		private String telno;
		/**
		 * 旺旺
		 */
		@ApiField("wangwang")
		private String wangwang;
		/**
		 * 网址
		 */
		@ApiField("website")
		private String website;
		/**
		 * 邮编
		 */
		@ApiField("zip")
		private String zip;
	

	public String getAccountBank() {
			return this.accountBank;
		}
		public void setAccountBank(String accountBank) {
			this.accountBank = accountBank;
		}
		public String getAccountBankNo() {
			return this.accountBankNo;
		}
		public void setAccountBankNo(String accountBankNo) {
			this.accountBankNo = accountBankNo;
		}
		public String getAddress() {
			return this.address;
		}
		public void setAddress(String address) {
			this.address = address;
		}
		public Long getArriveCycleDays() {
			return this.arriveCycleDays;
		}
		public void setArriveCycleDays(Long arriveCycleDays) {
			this.arriveCycleDays = arriveCycleDays;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getCollectName() {
			return this.collectName;
		}
		public void setCollectName(String collectName) {
			this.collectName = collectName;
		}
		public String getContact() {
			return this.contact;
		}
		public void setContact(String contact) {
			this.contact = contact;
		}
		public String getDistrict() {
			return this.district;
		}
		public void setDistrict(String district) {
			this.district = district;
		}
		public String getEmail() {
			return this.email;
		}
		public void setEmail(String email) {
			this.email = email;
		}
		public String getFax() {
			return this.fax;
		}
		public void setFax(String fax) {
			this.fax = fax;
		}
		public Long getIsDisabled() {
			return this.isDisabled;
		}
		public void setIsDisabled(Long isDisabled) {
			this.isDisabled = isDisabled;
		}
		public String getMobile() {
			return this.mobile;
		}
		public void setMobile(String mobile) {
			this.mobile = mobile;
		}
		public String getProviderName() {
			return this.providerName;
		}
		public void setProviderName(String providerName) {
			this.providerName = providerName;
		}
		public String getProviderNo() {
			return this.providerNo;
		}
		public void setProviderNo(String providerNo) {
			this.providerNo = providerNo;
		}
		public String getProvince() {
			return this.province;
		}
		public void setProvince(String province) {
			this.province = province;
		}
		public String getQq() {
			return this.qq;
		}
		public void setQq(String qq) {
			this.qq = qq;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getTelno() {
			return this.telno;
		}
		public void setTelno(String telno) {
			this.telno = telno;
		}
		public String getWangwang() {
			return this.wangwang;
		}
		public void setWangwang(String wangwang) {
			this.wangwang = wangwang;
		}
		public String getWebsite() {
			return this.website;
		}
		public void setWebsite(String website) {
			this.website = website;
		}
		public String getZip() {
			return this.zip;
		}
		public void setZip(String zip) {
			this.zip = zip;
		}

}



}