package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtSettingPurchaseproviderQuerydetailResponse;

/**
 * TOP API(QimenCloud): wdt.setting.purchaseprovider.querydetail request
 * 
 * @author top auto create
 * @since 1.0, 2022.11.16
 */
public class WdtSettingPurchaseproviderQuerydetailRequest extends BaseTaobaoRequest<WdtSettingPurchaseproviderQuerydetailResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.setting.purchaseprovider.querydetail";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtSettingPurchaseproviderQuerydetailResponse> getResponseClass() {
		return WdtSettingPurchaseproviderQuerydetailResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 联系人
		 */
		@ApiField("contact")
		private String contact;
		/**
		 * 创建时间查询开始时间
		 */
		@ApiField("created_begin")
		private String createdBegin;
		/**
		 * 创建时间查询结束时间
		 */
		@ApiField("created_end")
		private String createdEnd;
		/**
		 * 是否删除 0: 未删除
		 */
		@ApiField("deleted")
		private Long deleted;
		/**
		 * 采购平台供应商账户名
		 */
		@ApiField("description")
		private String description;
		/**
		 * 是否禁用1: 禁用,0未禁用
		 */
		@ApiField("is_disabled")
		private Long isDisabled;
		/**
		 * 手机
		 */
		@ApiField("mobile")
		private String mobile;
		/**
		 * 修改时间
		 */
		@ApiField("modified_begin")
		private String modifiedBegin;
		/**
		 * 修改时间
		 */
		@ApiField("modified_end")
		private String modifiedEnd;
		/**
		 * 供应商名称
		 */
		@ApiField("provider_name")
		private String providerName;
		/**
		 * 供应商编号
		 */
		@ApiField("provider_no")
		private String providerNo;
		/**
		 * 电话
		 */
		@ApiField("telno")
		private String telno;
	

	public String getContact() {
			return this.contact;
		}
		public void setContact(String contact) {
			this.contact = contact;
		}
		public String getCreatedBegin() {
			return this.createdBegin;
		}
		public void setCreatedBegin(String createdBegin) {
			this.createdBegin = createdBegin;
		}
		public String getCreatedEnd() {
			return this.createdEnd;
		}
		public void setCreatedEnd(String createdEnd) {
			this.createdEnd = createdEnd;
		}
		public Long getDeleted() {
			return this.deleted;
		}
		public void setDeleted(Long deleted) {
			this.deleted = deleted;
		}
		public String getDescription() {
			return this.description;
		}
		public void setDescription(String description) {
			this.description = description;
		}
		public Long getIsDisabled() {
			return this.isDisabled;
		}
		public void setIsDisabled(Long isDisabled) {
			this.isDisabled = isDisabled;
		}
		public String getMobile() {
			return this.mobile;
		}
		public void setMobile(String mobile) {
			this.mobile = mobile;
		}
		public String getModifiedBegin() {
			return this.modifiedBegin;
		}
		public void setModifiedBegin(String modifiedBegin) {
			this.modifiedBegin = modifiedBegin;
		}
		public String getModifiedEnd() {
			return this.modifiedEnd;
		}
		public void setModifiedEnd(String modifiedEnd) {
			this.modifiedEnd = modifiedEnd;
		}
		public String getProviderName() {
			return this.providerName;
		}
		public void setProviderName(String providerName) {
			this.providerName = providerName;
		}
		public String getProviderNo() {
			return this.providerNo;
		}
		public void setProviderNo(String providerNo) {
			this.providerNo = providerNo;
		}
		public String getTelno() {
			return this.telno;
		}
		public void setTelno(String telno) {
			this.telno = telno;
		}

}

	/**
 * 分页
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号 从0开始
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}



}