package com.qimencloud.api.scene3ldsmu02o9.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.internal.mapping.ApiListType;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockotherInPushResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockother.in.push request
 * 
 * @author top auto create
 * @since 1.0, 2023.04.23
 */
public class WdtWmsStockotherInPushRequest extends BaseTaobaoRequest<WdtWmsStockotherInPushResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 单据数据
	 */
	private String order;

	/** 
	* 单据明细
	 */
	private String orderDetails;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setOrder(String order) {
		this.order = order;
	}

	public void setOrder(Order order) {
		this.order = new JSONWriter(false,false,true).write(order);
	}

	public String getOrder() {
		return this.order;
	}

	public void setOrderDetails(String orderDetails) {
		this.orderDetails = orderDetails;
	}

	public void setOrderDetails(List<Orderdetails> orderDetails) {
		this.orderDetails = new JSONWriter(false,false,true).write(orderDetails);
	}

	public String getOrderDetails() {
		return this.orderDetails;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockother.in.push";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("order", this.order);
		txtParams.put("order_details", this.orderDetails);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockotherInPushResponse> getResponseClass() {
		return WdtWmsStockotherInPushResponse.class;
	}

     public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(orderDetails, 999999, "orderDetails");
     }
     
	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 标记名称
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 是否审核(传入false则创建的业务单为待审核状态)
		 */
		@ApiField("is_check")
		private Boolean isCheck;
		/**
		 * 物流公司(ERP系统内自行维护的物流公司的编号)
		 */
		@ApiField("logistics_code")
		private String logisticsCode;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 外部单号(传入外部单号则使用外部单号作为系统内业务单号)
		 */
		@ApiField("outer_no")
		private String outerNo;
		/**
		 * 其他入库业务单属性1
		 */
		@ApiField("prop1")
		private String prop1;
		/**
		 * 其他入库业务单属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 其他入库业务单属性3
		 */
		@ApiField("prop3")
		private String prop3;
		/**
		 * 其他入库业务单属性4
		 */
		@ApiField("prop4")
		private String prop4;
		/**
		 * 其他入库业务单属性5
		 */
		@ApiField("prop5")
		private String prop5;
		/**
		 * 其他入库业务单属性6
		 */
		@ApiField("prop6")
		private String prop6;
		/**
		 * 原因
		 */
		@ApiField("reason")
		private String reason;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public Boolean getIsCheck() {
			return this.isCheck;
		}
		public void setIsCheck(Boolean isCheck) {
			this.isCheck = isCheck;
		}
		public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getOuterNo() {
			return this.outerNo;
		}
		public void setOuterNo(String outerNo) {
			this.outerNo = outerNo;
		}
		public String getProp1() {
			return this.prop1;
		}
		public void setProp1(String prop1) {
			this.prop1 = prop1;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public String getProp3() {
			return this.prop3;
		}
		public void setProp3(String prop3) {
			this.prop3 = prop3;
		}
		public String getProp4() {
			return this.prop4;
		}
		public void setProp4(String prop4) {
			this.prop4 = prop4;
		}
		public String getProp5() {
			return this.prop5;
		}
		public void setProp5(String prop5) {
			this.prop5 = prop5;
		}
		public String getProp6() {
			return this.prop6;
		}
		public void setProp6(String prop6) {
			this.prop6 = prop6;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 单据明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 @ApiListType("orderdetails")
public static class Orderdetails {

	/**
		 * 辅助单位
		 */
		@ApiField("aux_unit_name")
		private String auxUnitName;
		/**
		 * 批次
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 是否残次品(默认false)
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 数量
		 */
		@ApiField("num")
		private Long num;
		/**
		 * 货位
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 入库价
		 */
		@ApiField("price")
		private String price;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
	

	public String getAuxUnitName() {
			return this.auxUnitName;
		}
		public void setAuxUnitName(String auxUnitName) {
			this.auxUnitName = auxUnitName;
		}
		public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public Long getNum() {
			return this.num;
		}
		public void setNum(Long num) {
			this.num = num;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}

}



}