package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockoutPurchasereturnQuerywithdetailResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockout.purchasereturn.querywithdetail request
 * 
 * @author top auto create
 * @since 1.0, 2023.03.10
 */
public class WdtWmsStockoutPurchasereturnQuerywithdetailRequest extends BaseTaobaoRequest<WdtWmsStockoutPurchasereturnQuerywithdetailResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页参数
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* sign
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockout.purchasereturn.querywithdetail";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockoutPurchasereturnQuerywithdetailResponse> getResponseClass() {
		return WdtWmsStockoutPurchasereturnQuerywithdetailResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 结束时间（出库单创建时间），上同开始时间
		 */
		@ApiField("create_end_time")
		private String createEndTime;
		/**
		 * 起始时间（出库单创建时间），若无出库单号或采购退货单号，则为必填。
		 */
		@ApiField("create_start_time")
		private String createStartTime;
		/**
		 * 结束时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 结束时间,结束时间（出库时间），上同开始时间
		 */
		@ApiField("out_end_time")
		private String outEndTime;
		/**
		 * 开始时间,起始时间（出库时间），若无出库单号或采购退货单号，则为必填。
		 */
		@ApiField("out_start_time")
		private String outStartTime;
		/**
		 * 是否按货位分组，等于0为否，不等于0为是，不填为否
		 */
		@ApiField("position")
		private Long position;
		/**
		 * 采购退货单号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 开始时间
		 */
		@ApiField("start_time")
		private String startTime;
		/**
		 * 出库单状态:   5已取消  48 未确认  50 待审核 77 拣货中,PDA拣货后 110已完成
		 */
		@ApiField("status")
		private String status;
		/**
		 * 出库单号
		 */
		@ApiField("stockout_no")
		private String stockoutNo;
		/**
		 * 时间类型
		 */
		@ApiField("time_type")
		private Long timeType;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getCreateEndTime() {
			return this.createEndTime;
		}
		public void setCreateEndTime(String createEndTime) {
			this.createEndTime = createEndTime;
		}
		public String getCreateStartTime() {
			return this.createStartTime;
		}
		public void setCreateStartTime(String createStartTime) {
			this.createStartTime = createStartTime;
		}
		public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public String getOutEndTime() {
			return this.outEndTime;
		}
		public void setOutEndTime(String outEndTime) {
			this.outEndTime = outEndTime;
		}
		public String getOutStartTime() {
			return this.outStartTime;
		}
		public void setOutStartTime(String outStartTime) {
			this.outStartTime = outStartTime;
		}
		public Long getPosition() {
			return this.position;
		}
		public void setPosition(Long position) {
			this.position = position;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public String getStartTime() {
			return this.startTime;
		}
		public void setStartTime(String startTime) {
			this.startTime = startTime;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getStockoutNo() {
			return this.stockoutNo;
		}
		public void setStockoutNo(String stockoutNo) {
			this.stockoutNo = stockoutNo;
		}
		public Long getTimeType() {
			return this.timeType;
		}
		public void setTimeType(Long timeType) {
			this.timeType = timeType;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 分页参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}



}