package com.qimencloud.api.scene3ldsmu02o9.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.Constants;
import com.taobao.api.internal.util.json.JSONWriter;

import com.qimencloud.api.scene3ldsmu02o9.response.WdtWmsStockoutTransferQuerywithdetailResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockout.transfer.querywithdetail request
 * 
 * @author top auto create
 * @since 1.0, 2023.03.10
 */
public class WdtWmsStockoutTransferQuerywithdetailRequest extends BaseTaobaoRequest<WdtWmsStockoutTransferQuerywithdetailResponse> {
     
     

	/** 
	* 时间
	 */
	private String datetime;

	/** 
	* 分页
	 */
	private String pager;

	/** 
	* 查询参数
	 */
	private String params;

	/** 
	* wdt_appkey
	 */
	private String wdtAppkey;

	/** 
	* wdt_salt
	 */
	private String wdtSalt;

	/** 
	* 签名旺店通签名
	 */
	private String wdtSign;

	public void setDatetime(String datetime) {
		this.datetime = datetime;
	}

	public String getDatetime() {
		return this.datetime;
	}

	public void setPager(String pager) {
		this.pager = pager;
	}

	public void setPager(Pager pager) {
		this.pager = new JSONWriter(false,false,true).write(pager);
	}

	public String getPager() {
		return this.pager;
	}

	public void setParams(String params) {
		this.params = params;
	}

	public void setParams(Params params) {
		this.params = new JSONWriter(false,false,true).write(params);
	}

	public String getParams() {
		return this.params;
	}

	public void setWdtAppkey(String wdtAppkey) {
		this.wdtAppkey = wdtAppkey;
	}

	public String getWdtAppkey() {
		return this.wdtAppkey;
	}

	public void setWdtSalt(String wdtSalt) {
		this.wdtSalt = wdtSalt;
	}

	public String getWdtSalt() {
		return this.wdtSalt;
	}

	public void setWdtSign(String wdtSign) {
		this.wdtSign = wdtSign;
	}

	public String getWdtSign() {
		return this.wdtSign;
	}

     public String getApiMethodName() {
        return "wdt.wms.stockout.transfer.querywithdetail";
     }

     private String topContentType ;

     public String getTopContentType() {
        return topContentType;
     }

     public void setTopContentType(String topContentType) {
         this.topContentType = topContentType;
     }

     private String topResponseType = Constants.RESPONSE_TYPE_QIMEN;

     public String getTopResponseType() {
        return topResponseType;
     }

     public void setTopResponseType(String topResponseType) {
        this.topResponseType = topResponseType;
     }

    private String topApiVersion = "2.0";

     public String getTopApiVersion() {
        return this.topApiVersion;
     }

     public void setTopApiVersion(String topApiVersion) {
        this.topApiVersion = topApiVersion;
     }

     private String topApiFormat ;

     public String getTopApiFormat() {
     	return this.topApiFormat;
     }

     public void setTopApiFormat(String topApiFormat) {
     	this.topApiFormat = topApiFormat;
     }
     
     public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("datetime", this.datetime);
		txtParams.put("pager", this.pager);
		txtParams.put("params", this.params);
		txtParams.put("wdt_appkey", this.wdtAppkey);
		txtParams.put("wdt_salt", this.wdtSalt);
		txtParams.put("wdt_sign", this.wdtSign);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}
     
     public Class<WdtWmsStockoutTransferQuerywithdetailResponse> getResponseClass() {
		return WdtWmsStockoutTransferQuerywithdetailResponse.class;
	}

     public void check() throws ApiRuleException {
     }
     
	/**
 * 查询参数
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Params {

	/**
		 * 结束时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 是否按照货位分组
		 */
		@ApiField("position")
		private String position;
		/**
		 * 源单号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 开始时间
		 */
		@ApiField("start_time")
		private String startTime;
		/**
		 * 由逗号隔开的整数字符串（使用该字段需要客户端升级到1.2.3.6及以上版本！！）  出库单状态:   5已取消  48 未确认  50 待审核 77 拣货中,PDA拣货后 110已完成
		 */
		@ApiField("status")
		private String status;
		/**
		 * 出库单号
		 */
		@ApiField("stockout_no")
		private String stockoutNo;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public String getPosition() {
			return this.position;
		}
		public void setPosition(String position) {
			this.position = position;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public String getStartTime() {
			return this.startTime;
		}
		public void setStartTime(String startTime) {
			this.startTime = startTime;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public String getStockoutNo() {
			return this.stockoutNo;
		}
		public void setStockoutNo(String stockoutNo) {
			this.stockoutNo = stockoutNo;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 分页
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Pager {

	/**
		 * 页号
		 */
		@ApiField("page_no")
		private String pageNo;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private String pageSize;
	

	public String getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(String pageNo) {
			this.pageNo = pageNo;
		}
		public String getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(String pageSize) {
			this.pageSize = pageSize;
		}

}



}