package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.aftersales.refund.refund.search response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtAftersalesRefundRefundSearchResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2142833914332777113L;

	/** 
	 * 单据数据
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态0表示调用成功,在调用错误时候不返回该值。
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 退换详情
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailList {

	/**
		 * 平台货品名称
		 */
		@ApiField("api_goods_name")
		private String apiGoodsName;
		/**
		 * 平台规格名称
		 */
		@ApiField("api_spec_name")
		private String apiSpecName;
		/**
		 * 条码
		 */
		@ApiField("barcode")
		private String barcode;
		/**
		 * 成本价
		 */
		@ApiField("checked_cost_price")
		private String checkedCostPrice;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 总折扣金额
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 平台货品id
		 */
		@ApiField("goods_id")
		private String goodsId;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 是否担保退款
		 */
		@ApiField("is_guarantee")
		private Boolean isGuarantee;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified_date")
		private String modifiedDate;
		/**
		 * 数量 实际发出数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 原始子单号
		 */
		@ApiField("oid")
		private String oid;
		/**
		 * 原价
		 */
		@ApiField("original_price")
		private String originalPrice;
		/**
		 * 已支付金额
		 */
		@ApiField("paid")
		private String paid;
		/**
		 * 组合装数量
		 */
		@ApiField("plat_goods_count")
		private String platGoodsCount;
		/**
		 * 平台id 平台id,见附录
		 */
		@ApiField("platform_id")
		private Long platformId;
		/**
		 * 价格
		 */
		@ApiField("price")
		private String price;
		/**
		 * 原始退款单号与客户端子单明细取值保持一致
		 */
		@ApiField("raw_refund_no")
		private String rawRefundNo;
		/**
		 * 原始退款单号 多个原始退款单号之间使用英文逗号隔开
		 */
		@ApiField("raw_refund_nos")
		private String rawRefundNos;
		/**
		 * 退换单明细Id
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 退款货品总额
		 */
		@ApiField("refund_amount")
		private String refundAmount;
		/**
		 * 退换单id
		 */
		@ApiField("refund_id")
		private Long refundId;
		/**
		 * 退款数量
		 */
		@ApiField("refund_num")
		private String refundNum;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 订单id
		 */
		@ApiField("sales_trade_id")
		private Long salesTradeId;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 平台规格id
		 */
		@ApiField("spec_id")
		private String specId;
		/**
		 * 单品名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 退货入库数量
		 */
		@ApiField("stockin_num")
		private String stockinNum;
		/**
		 * 组合装id
		 */
		@ApiField("suite_id")
		private Long suiteId;
		/**
		 * 组合装名称
		 */
		@ApiField("suite_name")
		private String suiteName;
		/**
		 * 组合装编码
		 */
		@ApiField("suite_no")
		private String suiteNo;
		/**
		 * 组合装数量
		 */
		@ApiField("suite_num")
		private String suiteNum;
		/**
		 * 系统货品id
		 */
		@ApiField("sys_goods_id")
		private Long sysGoodsId;
		/**
		 * 系统单品id
		 */
		@ApiField("sys_spec_id")
		private Long sysSpecId;
		/**
		 * 原始单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 退款货品总额
		 */
		@ApiField("total_amount")
		private String totalAmount;
		/**
		 * 系统订单编号
		 */
		@ApiField("trade_no")
		private String tradeNo;
		/**
		 * 系统订单id
		 */
		@ApiField("trade_order_id")
		private Long tradeOrderId;
	

	public String getApiGoodsName() {
			return this.apiGoodsName;
		}
		public void setApiGoodsName(String apiGoodsName) {
			this.apiGoodsName = apiGoodsName;
		}
		public String getApiSpecName() {
			return this.apiSpecName;
		}
		public void setApiSpecName(String apiSpecName) {
			this.apiSpecName = apiSpecName;
		}
		public String getBarcode() {
			return this.barcode;
		}
		public void setBarcode(String barcode) {
			this.barcode = barcode;
		}
		public String getCheckedCostPrice() {
			return this.checkedCostPrice;
		}
		public void setCheckedCostPrice(String checkedCostPrice) {
			this.checkedCostPrice = checkedCostPrice;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getGoodsId() {
			return this.goodsId;
		}
		public void setGoodsId(String goodsId) {
			this.goodsId = goodsId;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public Boolean getIsGuarantee() {
			return this.isGuarantee;
		}
		public void setIsGuarantee(Boolean isGuarantee) {
			this.isGuarantee = isGuarantee;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getModifiedDate() {
			return this.modifiedDate;
		}
		public void setModifiedDate(String modifiedDate) {
			this.modifiedDate = modifiedDate;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getOid() {
			return this.oid;
		}
		public void setOid(String oid) {
			this.oid = oid;
		}
		public String getOriginalPrice() {
			return this.originalPrice;
		}
		public void setOriginalPrice(String originalPrice) {
			this.originalPrice = originalPrice;
		}
		public String getPaid() {
			return this.paid;
		}
		public void setPaid(String paid) {
			this.paid = paid;
		}
		public String getPlatGoodsCount() {
			return this.platGoodsCount;
		}
		public void setPlatGoodsCount(String platGoodsCount) {
			this.platGoodsCount = platGoodsCount;
		}
		public Long getPlatformId() {
			return this.platformId;
		}
		public void setPlatformId(Long platformId) {
			this.platformId = platformId;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getRawRefundNo() {
			return this.rawRefundNo;
		}
		public void setRawRefundNo(String rawRefundNo) {
			this.rawRefundNo = rawRefundNo;
		}
		public String getRawRefundNos() {
			return this.rawRefundNos;
		}
		public void setRawRefundNos(String rawRefundNos) {
			this.rawRefundNos = rawRefundNos;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getRefundAmount() {
			return this.refundAmount;
		}
		public void setRefundAmount(String refundAmount) {
			this.refundAmount = refundAmount;
		}
		public Long getRefundId() {
			return this.refundId;
		}
		public void setRefundId(Long refundId) {
			this.refundId = refundId;
		}
		public String getRefundNum() {
			return this.refundNum;
		}
		public void setRefundNum(String refundNum) {
			this.refundNum = refundNum;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public Long getSalesTradeId() {
			return this.salesTradeId;
		}
		public void setSalesTradeId(Long salesTradeId) {
			this.salesTradeId = salesTradeId;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public String getSpecId() {
			return this.specId;
		}
		public void setSpecId(String specId) {
			this.specId = specId;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getStockinNum() {
			return this.stockinNum;
		}
		public void setStockinNum(String stockinNum) {
			this.stockinNum = stockinNum;
		}
		public Long getSuiteId() {
			return this.suiteId;
		}
		public void setSuiteId(Long suiteId) {
			this.suiteId = suiteId;
		}
		public String getSuiteName() {
			return this.suiteName;
		}
		public void setSuiteName(String suiteName) {
			this.suiteName = suiteName;
		}
		public String getSuiteNo() {
			return this.suiteNo;
		}
		public void setSuiteNo(String suiteNo) {
			this.suiteNo = suiteNo;
		}
		public String getSuiteNum() {
			return this.suiteNum;
		}
		public void setSuiteNum(String suiteNum) {
			this.suiteNum = suiteNum;
		}
		public Long getSysGoodsId() {
			return this.sysGoodsId;
		}
		public void setSysGoodsId(Long sysGoodsId) {
			this.sysGoodsId = sysGoodsId;
		}
		public Long getSysSpecId() {
			return this.sysSpecId;
		}
		public void setSysSpecId(Long sysSpecId) {
			this.sysSpecId = sysSpecId;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(String totalAmount) {
			this.totalAmount = totalAmount;
		}
		public String getTradeNo() {
			return this.tradeNo;
		}
		public void setTradeNo(String tradeNo) {
			this.tradeNo = tradeNo;
		}
		public Long getTradeOrderId() {
			return this.tradeOrderId;
		}
		public void setTradeOrderId(Long tradeOrderId) {
			this.tradeOrderId = tradeOrderId;
		}

}

	/**
 * 金额明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Amountdetaillist {

	/**
		 * 开户银行
		 */
		@ApiField("account_bank")
		private String accountBank;
		/**
		 * 支付账号
		 */
		@ApiField("account_id")
		private Long accountId;
		/**
		 * 买家开户人姓名
		 */
		@ApiField("account_name")
		private String accountName;
		/**
		 * 是否系统自动生成
		 */
		@ApiField("is_auto")
		private Boolean isAuto;
		/**
		 * 是否担保支付
		 */
		@ApiField("is_guarantee")
		private Boolean isGuarantee;
		/**
		 * 金额流向
		 */
		@ApiField("is_return")
		private Long isReturn;
		/**
		 * 买家账号
		 */
		@ApiField("pay_account")
		private String payAccount;
		/**
		 * 金额明细记录id
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 收款金额
		 */
		@ApiField("receive_amount")
		private String receiveAmount;
		/**
		 * 退款金额
		 */
		@ApiField("refund_amount")
		private String refundAmount;
		/**
		 * 退换单id
		 */
		@ApiField("refund_id")
		private Long refundId;
		/**
		 * 退换类型
		 */
		@ApiField("refund_type")
		private Long refundType;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
	

	public String getAccountBank() {
			return this.accountBank;
		}
		public void setAccountBank(String accountBank) {
			this.accountBank = accountBank;
		}
		public Long getAccountId() {
			return this.accountId;
		}
		public void setAccountId(Long accountId) {
			this.accountId = accountId;
		}
		public String getAccountName() {
			return this.accountName;
		}
		public void setAccountName(String accountName) {
			this.accountName = accountName;
		}
		public Boolean getIsAuto() {
			return this.isAuto;
		}
		public void setIsAuto(Boolean isAuto) {
			this.isAuto = isAuto;
		}
		public Boolean getIsGuarantee() {
			return this.isGuarantee;
		}
		public void setIsGuarantee(Boolean isGuarantee) {
			this.isGuarantee = isGuarantee;
		}
		public Long getIsReturn() {
			return this.isReturn;
		}
		public void setIsReturn(Long isReturn) {
			this.isReturn = isReturn;
		}
		public String getPayAccount() {
			return this.payAccount;
		}
		public void setPayAccount(String payAccount) {
			this.payAccount = payAccount;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getReceiveAmount() {
			return this.receiveAmount;
		}
		public void setReceiveAmount(String receiveAmount) {
			this.receiveAmount = receiveAmount;
		}
		public String getRefundAmount() {
			return this.refundAmount;
		}
		public void setRefundAmount(String refundAmount) {
			this.refundAmount = refundAmount;
		}
		public Long getRefundId() {
			return this.refundId;
		}
		public void setRefundId(Long refundId) {
			this.refundId = refundId;
		}
		public Long getRefundType() {
			return this.refundType;
		}
		public void setRefundType(Long refundType) {
			this.refundType = refundType;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}

}

	/**
 * 换出订单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class SwapOrderDetailList {

	/**
		 * 是否残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 商家编码商家编码,换出货品为组合装则此编码为组合装的商家编码
		 */
		@ApiField("merchant_no")
		private String merchantNo;
		/**
		 * 数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 原始子单号
		 */
		@ApiField("oid")
		private String oid;
		/**
		 * 价格 零售价
		 */
		@ApiField("price")
		private String price;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 规格名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 换出货品id
		 */
		@ApiField("target_id")
		private Long targetId;
		/**
		 * 货品类型
		 */
		@ApiField("target_type")
		private Long targetType;
		/**
		 * 总金额
		 */
		@ApiField("total_amount")
		private String totalAmount;
	

	public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public String getMerchantNo() {
			return this.merchantNo;
		}
		public void setMerchantNo(String merchantNo) {
			this.merchantNo = merchantNo;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getOid() {
			return this.oid;
		}
		public void setOid(String oid) {
			this.oid = oid;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public Long getTargetId() {
			return this.targetId;
		}
		public void setTargetId(Long targetId) {
			this.targetId = targetId;
		}
		public Long getTargetType() {
			return this.targetType;
		}
		public void setTargetType(Long targetType) {
			this.targetType = targetType;
		}
		public String getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(String totalAmount) {
			this.totalAmount = totalAmount;
		}

}

	/**
 * 换出订单 非换货类型不返回
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class SwapOrder {

	/**
		 * 其他金额
		 */
		@ApiField("other_amount")
		private String otherAmount;
		/**
		 * 换货邮费
		 */
		@ApiField("post_amount")
		private String postAmount;
		/**
		 * 店铺id
		 */
		@ApiField("shop_id")
		private Long shopId;
		/**
		 * 店铺名称
		 */
		@ApiField("shop_name")
		private String shopName;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_no")
		private String shopNo;
		/**
		 * 地区
		 */
		@ApiField("swap_area")
		private String swapArea;
		/**
		 * 城市id
		 */
		@ApiField("swap_city")
		private Long swapCity;
		/**
		 * 地区id
		 */
		@ApiField("swap_district")
		private Long swapDistrict;
		/**
		 * 换货新订单物流公司id
		 */
		@ApiField("swap_logistics_id")
		private Long swapLogisticsId;
		/**
		 * 换出订单明细
		 */
		@ApiListField("swap_order_detail_list")
		@ApiField("swapOrderDetailList")
		private List<SwapOrderDetailList> swapOrderDetailList;
		/**
		 * 省份id
		 */
		@ApiField("swap_province")
		private Long swapProvince;
		/**
		 * 换出订单原始单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 仓库id
		 */
		@ApiField("warehouse_id")
		private Long warehouseId;
		/**
		 * 仓库名称
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getOtherAmount() {
			return this.otherAmount;
		}
		public void setOtherAmount(String otherAmount) {
			this.otherAmount = otherAmount;
		}
		public String getPostAmount() {
			return this.postAmount;
		}
		public void setPostAmount(String postAmount) {
			this.postAmount = postAmount;
		}
		public Long getShopId() {
			return this.shopId;
		}
		public void setShopId(Long shopId) {
			this.shopId = shopId;
		}
		public String getShopName() {
			return this.shopName;
		}
		public void setShopName(String shopName) {
			this.shopName = shopName;
		}
		public String getShopNo() {
			return this.shopNo;
		}
		public void setShopNo(String shopNo) {
			this.shopNo = shopNo;
		}
		public String getSwapArea() {
			return this.swapArea;
		}
		public void setSwapArea(String swapArea) {
			this.swapArea = swapArea;
		}
		public Long getSwapCity() {
			return this.swapCity;
		}
		public void setSwapCity(Long swapCity) {
			this.swapCity = swapCity;
		}
		public Long getSwapDistrict() {
			return this.swapDistrict;
		}
		public void setSwapDistrict(Long swapDistrict) {
			this.swapDistrict = swapDistrict;
		}
		public Long getSwapLogisticsId() {
			return this.swapLogisticsId;
		}
		public void setSwapLogisticsId(Long swapLogisticsId) {
			this.swapLogisticsId = swapLogisticsId;
		}
		public List<SwapOrderDetailList> getSwapOrderDetailList() {
			return this.swapOrderDetailList;
		}
		public void setSwapOrderDetailList(List<SwapOrderDetailList> swapOrderDetailList) {
			this.swapOrderDetailList = swapOrderDetailList;
		}
		public Long getSwapProvince() {
			return this.swapProvince;
		}
		public void setSwapProvince(Long swapProvince) {
			this.swapProvince = swapProvince;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public Long getWarehouseId() {
			return this.warehouseId;
		}
		public void setWarehouseId(Long warehouseId) {
			this.warehouseId = warehouseId;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 实际退款金额
		 */
		@ApiField("actual_refund_amount")
		private String actualRefundAmount;
		/**
		 * 金额明细
		 */
		@ApiListField("amount_detail_list")
		@ApiField("amountdetaillist")
		private List<Amountdetaillist> amountDetailList;
		/**
		 * 拦截原因
		 */
		@ApiField("bad_reason")
		private Long badReason;
		/**
		 * 客户网名（只返回自有平台及线下平台的网名信息，淘系的不返回）
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 审核时间
		 */
		@ApiField("check_time")
		private String checkTime;
		/**
		 * 发货方式
		 */
		@ApiField("consign_mode")
		private Long consignMode;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 客户id
		 */
		@ApiField("customer_id")
		private Long customerId;
		/**
		 * 客户姓名（只返回自有平台及线下平台的网名信息，淘系的不返回）
		 */
		@ApiField("customer_name")
		private String customerName;
		/**
		 * 退换详情
		 */
		@ApiListField("detail_list")
		@ApiField("detailList")
		private List<DetailList> detailList;
		/**
		 * 非担保退款金额
		 */
		@ApiField("direct_refund_amount")
		private String directRefundAmount;
		/**
		 * 分销商昵称
		 */
		@ApiField("fenxiao_nick_name")
		private String fenxiaoNickName;
		/**
		 * 分销商编码
		 */
		@ApiField("fenxiao_nick_no")
		private String fenxiaoNickNo;
		/**
		 * 分销原始单号
		 */
		@ApiField("fenxiao_tid")
		private String fenxiaoTid;
		/**
		 * 标记名称
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 建单方式 0:API抓单;1:手工建单;2:导入
		 */
		@ApiField("from_type")
		private Long fromType;
		/**
		 * 担保退款金额
		 */
		@ApiField("guarantee_refund_amount")
		private String guaranteeRefundAmount;
		/**
		 * 修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified_date")
		private String modifiedDate;
		/**
		 * 便签数量
		 */
		@ApiField("note_count")
		private Long noteCount;
		/**
		 * 制单员姓名
		 */
		@ApiField("operator_name")
		private String operatorName;
		/**
		 * 支付订单号
		 */
		@ApiField("pay_id")
		private String payId;
		/**
		 * 平台id
		 */
		@ApiField("platform_id")
		private Long platformId;
		/**
		 * 处理状态
		 */
		@ApiField("process_status")
		private Long processStatus;
		/**
		 * 分销原始单号
		 */
		@ApiField("provider_refund_no")
		private String providerRefundNo;
		/**
		 * 原始退换单号
		 */
		@ApiField("raw_refund_nos")
		private String rawRefundNos;
		/**
		 * 退款原因id
		 */
		@ApiField("reason_id")
		private Long reasonId;
		/**
		 * 退换标记
		 */
		@ApiField("reason_name")
		private String reasonName;
		/**
		 * 收款金额
		 */
		@ApiField("receive_amount")
		private String receiveAmount;
		/**
		 * 退款订单中的收件人姓名
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 退款订单中的收件人手机
		 */
		@ApiField("receiver_telno")
		private String receiverTelno;
		/**
		 * 退换单id
		 */
		@ApiField("refund_id")
		private Long refundId;
		/**
		 * 退换单号
		 */
		@ApiField("refund_no")
		private String refundNo;
		/**
		 * 退款原因
		 */
		@ApiField("refund_reason")
		private String refundReason;
		/**
		 * 退款创建时间
		 */
		@ApiField("refund_time")
		private String refundTime;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 退回货品金额
		 */
		@ApiField("return_goods_amount")
		private String returnGoodsAmount;
		/**
		 * 退回货品数量
		 */
		@ApiField("return_goods_count")
		private String returnGoodsCount;
		/**
		 * 物流公司名称
		 */
		@ApiField("return_logistics_name")
		private String returnLogisticsName;
		/**
		 * 退货物流单号
		 */
		@ApiField("return_logistics_no")
		private String returnLogisticsNo;
		/**
		 * 退换信息
		 */
		@ApiField("return_mask_info")
		private String returnMaskInfo;
		/**
		 * 退回仓库id
		 */
		@ApiField("return_warehouse_id")
		private Long returnWarehouseId;
		/**
		 * 退回仓库编号
		 */
		@ApiField("return_warehouse_no")
		private String returnWarehouseNo;
		/**
		 * 驳回原因id
		 */
		@ApiField("revert_reason")
		private Long revertReason;
		/**
		 * 驳回原因
		 */
		@ApiField("revert_reason_name")
		private String revertReasonName;
		/**
		 * 使用结算时间查询返回结算时间, 否则返回空字符串
		 */
		@ApiField("settle_time")
		private String settleTime;
		/**
		 * 店铺id
		 */
		@ApiField("shop_id")
		private Long shopId;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_no")
		private String shopNo;
		/**
		 * 店铺平台id
		 */
		@ApiField("shop_platform_id")
		private Long shopPlatformId;
		/**
		 * 原始单号
		 */
		@ApiField("src_tids")
		private String srcTids;
		/**
		 * 退换单状态
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 入库状态见传入参数描述
		 */
		@ApiField("stockin_status")
		private Long stockinStatus;
		/**
		 * 子平台id
		 */
		@ApiField("sub_platform_id")
		private Long subPlatformId;
		/**
		 * 换出订单 非换货类型不返回
		 */
		@ApiField("swap_order")
		private SwapOrder swapOrder;
		/**
		 * 原始单号
		 */
		@ApiField("tid_list")
		private String tidList;
		/**
		 * 订单id
		 */
		@ApiField("trade_id")
		private Long tradeId;
		/**
		 * 系统订单号列表
		 */
		@ApiField("trade_no_list")
		private String tradeNoList;
		/**
		 * 退换单类型 见传入参数描述
		 */
		@ApiField("type")
		private Long type;
		/**
		 * 退回仓库类型
		 */
		@ApiField("warehouse_type")
		private Long warehouseType;
		/**
		 * 奇门货主编号
		 */
		@ApiField("wms_owner_no")
		private String wmsOwnerNo;
	

	public String getActualRefundAmount() {
			return this.actualRefundAmount;
		}
		public void setActualRefundAmount(String actualRefundAmount) {
			this.actualRefundAmount = actualRefundAmount;
		}
		public List<Amountdetaillist> getAmountDetailList() {
			return this.amountDetailList;
		}
		public void setAmountDetailList(List<Amountdetaillist> amountDetailList) {
			this.amountDetailList = amountDetailList;
		}
		public Long getBadReason() {
			return this.badReason;
		}
		public void setBadReason(Long badReason) {
			this.badReason = badReason;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getCheckTime() {
			return this.checkTime;
		}
		public void setCheckTime(String checkTime) {
			this.checkTime = checkTime;
		}
		public Long getConsignMode() {
			return this.consignMode;
		}
		public void setConsignMode(Long consignMode) {
			this.consignMode = consignMode;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public Long getCustomerId() {
			return this.customerId;
		}
		public void setCustomerId(Long customerId) {
			this.customerId = customerId;
		}
		public String getCustomerName() {
			return this.customerName;
		}
		public void setCustomerName(String customerName) {
			this.customerName = customerName;
		}
		public List<DetailList> getDetailList() {
			return this.detailList;
		}
		public void setDetailList(List<DetailList> detailList) {
			this.detailList = detailList;
		}
		public String getDirectRefundAmount() {
			return this.directRefundAmount;
		}
		public void setDirectRefundAmount(String directRefundAmount) {
			this.directRefundAmount = directRefundAmount;
		}
		public String getFenxiaoNickName() {
			return this.fenxiaoNickName;
		}
		public void setFenxiaoNickName(String fenxiaoNickName) {
			this.fenxiaoNickName = fenxiaoNickName;
		}
		public String getFenxiaoNickNo() {
			return this.fenxiaoNickNo;
		}
		public void setFenxiaoNickNo(String fenxiaoNickNo) {
			this.fenxiaoNickNo = fenxiaoNickNo;
		}
		public String getFenxiaoTid() {
			return this.fenxiaoTid;
		}
		public void setFenxiaoTid(String fenxiaoTid) {
			this.fenxiaoTid = fenxiaoTid;
		}
		public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public Long getFromType() {
			return this.fromType;
		}
		public void setFromType(Long fromType) {
			this.fromType = fromType;
		}
		public String getGuaranteeRefundAmount() {
			return this.guaranteeRefundAmount;
		}
		public void setGuaranteeRefundAmount(String guaranteeRefundAmount) {
			this.guaranteeRefundAmount = guaranteeRefundAmount;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getModifiedDate() {
			return this.modifiedDate;
		}
		public void setModifiedDate(String modifiedDate) {
			this.modifiedDate = modifiedDate;
		}
		public Long getNoteCount() {
			return this.noteCount;
		}
		public void setNoteCount(Long noteCount) {
			this.noteCount = noteCount;
		}
		public String getOperatorName() {
			return this.operatorName;
		}
		public void setOperatorName(String operatorName) {
			this.operatorName = operatorName;
		}
		public String getPayId() {
			return this.payId;
		}
		public void setPayId(String payId) {
			this.payId = payId;
		}
		public Long getPlatformId() {
			return this.platformId;
		}
		public void setPlatformId(Long platformId) {
			this.platformId = platformId;
		}
		public Long getProcessStatus() {
			return this.processStatus;
		}
		public void setProcessStatus(Long processStatus) {
			this.processStatus = processStatus;
		}
		public String getProviderRefundNo() {
			return this.providerRefundNo;
		}
		public void setProviderRefundNo(String providerRefundNo) {
			this.providerRefundNo = providerRefundNo;
		}
		public String getRawRefundNos() {
			return this.rawRefundNos;
		}
		public void setRawRefundNos(String rawRefundNos) {
			this.rawRefundNos = rawRefundNos;
		}
		public Long getReasonId() {
			return this.reasonId;
		}
		public void setReasonId(Long reasonId) {
			this.reasonId = reasonId;
		}
		public String getReasonName() {
			return this.reasonName;
		}
		public void setReasonName(String reasonName) {
			this.reasonName = reasonName;
		}
		public String getReceiveAmount() {
			return this.receiveAmount;
		}
		public void setReceiveAmount(String receiveAmount) {
			this.receiveAmount = receiveAmount;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public String getReceiverTelno() {
			return this.receiverTelno;
		}
		public void setReceiverTelno(String receiverTelno) {
			this.receiverTelno = receiverTelno;
		}
		public Long getRefundId() {
			return this.refundId;
		}
		public void setRefundId(Long refundId) {
			this.refundId = refundId;
		}
		public String getRefundNo() {
			return this.refundNo;
		}
		public void setRefundNo(String refundNo) {
			this.refundNo = refundNo;
		}
		public String getRefundReason() {
			return this.refundReason;
		}
		public void setRefundReason(String refundReason) {
			this.refundReason = refundReason;
		}
		public String getRefundTime() {
			return this.refundTime;
		}
		public void setRefundTime(String refundTime) {
			this.refundTime = refundTime;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getReturnGoodsAmount() {
			return this.returnGoodsAmount;
		}
		public void setReturnGoodsAmount(String returnGoodsAmount) {
			this.returnGoodsAmount = returnGoodsAmount;
		}
		public String getReturnGoodsCount() {
			return this.returnGoodsCount;
		}
		public void setReturnGoodsCount(String returnGoodsCount) {
			this.returnGoodsCount = returnGoodsCount;
		}
		public String getReturnLogisticsName() {
			return this.returnLogisticsName;
		}
		public void setReturnLogisticsName(String returnLogisticsName) {
			this.returnLogisticsName = returnLogisticsName;
		}
		public String getReturnLogisticsNo() {
			return this.returnLogisticsNo;
		}
		public void setReturnLogisticsNo(String returnLogisticsNo) {
			this.returnLogisticsNo = returnLogisticsNo;
		}
		public String getReturnMaskInfo() {
			return this.returnMaskInfo;
		}
		public void setReturnMaskInfo(String returnMaskInfo) {
			this.returnMaskInfo = returnMaskInfo;
		}
		public Long getReturnWarehouseId() {
			return this.returnWarehouseId;
		}
		public void setReturnWarehouseId(Long returnWarehouseId) {
			this.returnWarehouseId = returnWarehouseId;
		}
		public String getReturnWarehouseNo() {
			return this.returnWarehouseNo;
		}
		public void setReturnWarehouseNo(String returnWarehouseNo) {
			this.returnWarehouseNo = returnWarehouseNo;
		}
		public Long getRevertReason() {
			return this.revertReason;
		}
		public void setRevertReason(Long revertReason) {
			this.revertReason = revertReason;
		}
		public String getRevertReasonName() {
			return this.revertReasonName;
		}
		public void setRevertReasonName(String revertReasonName) {
			this.revertReasonName = revertReasonName;
		}
		public String getSettleTime() {
			return this.settleTime;
		}
		public void setSettleTime(String settleTime) {
			this.settleTime = settleTime;
		}
		public Long getShopId() {
			return this.shopId;
		}
		public void setShopId(Long shopId) {
			this.shopId = shopId;
		}
		public String getShopNo() {
			return this.shopNo;
		}
		public void setShopNo(String shopNo) {
			this.shopNo = shopNo;
		}
		public Long getShopPlatformId() {
			return this.shopPlatformId;
		}
		public void setShopPlatformId(Long shopPlatformId) {
			this.shopPlatformId = shopPlatformId;
		}
		public String getSrcTids() {
			return this.srcTids;
		}
		public void setSrcTids(String srcTids) {
			this.srcTids = srcTids;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public Long getStockinStatus() {
			return this.stockinStatus;
		}
		public void setStockinStatus(Long stockinStatus) {
			this.stockinStatus = stockinStatus;
		}
		public Long getSubPlatformId() {
			return this.subPlatformId;
		}
		public void setSubPlatformId(Long subPlatformId) {
			this.subPlatformId = subPlatformId;
		}
		public SwapOrder getSwapOrder() {
			return this.swapOrder;
		}
		public void setSwapOrder(SwapOrder swapOrder) {
			this.swapOrder = swapOrder;
		}
		public String getTidList() {
			return this.tidList;
		}
		public void setTidList(String tidList) {
			this.tidList = tidList;
		}
		public Long getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(Long tradeId) {
			this.tradeId = tradeId;
		}
		public String getTradeNoList() {
			return this.tradeNoList;
		}
		public void setTradeNoList(String tradeNoList) {
			this.tradeNoList = tradeNoList;
		}
		public Long getType() {
			return this.type;
		}
		public void setType(Long type) {
			this.type = type;
		}
		public Long getWarehouseType() {
			return this.warehouseType;
		}
		public void setWarehouseType(Long warehouseType) {
			this.warehouseType = warehouseType;
		}
		public String getWmsOwnerNo() {
			return this.wmsOwnerNo;
		}
		public void setWmsOwnerNo(String wmsOwnerNo) {
			this.wmsOwnerNo = wmsOwnerNo;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据数据
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 数据总条数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
