package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.sales.rawtrade.searchhistory response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtSalesRawtradeSearchhistoryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6191494541789651874L;

	/** 
	 * 单据信息
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 优惠明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DiscountList {

	/**
		 * 金额
		 */
		@ApiField("amount")
		private String amount;
		/**
		 * 详情
		 */
		@ApiField("detail")
		private String detail;
		/**
		 * 优惠名称
		 */
		@ApiField("name")
		private String name;
		/**
		 * 原始子单号
		 */
		@ApiField("oid")
		private String oid;
		/**
		 * 类型
		 */
		@ApiField("type")
		private String type;
	

	public String getAmount() {
			return this.amount;
		}
		public void setAmount(String amount) {
			this.amount = amount;
		}
		public String getDetail() {
			return this.detail;
		}
		public void setDetail(String detail) {
			this.detail = detail;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getOid() {
			return this.oid;
		}
		public void setOid(String oid) {
			this.oid = oid;
		}
		public String getType() {
			return this.type;
		}
		public void setType(String type) {
			this.type = type;
		}

}

	/**
 * 原始单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class TradeOrders {

	/**
		 * 调整价
		 */
		@ApiField("adjust_amount")
		private String adjustAmount;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 优惠
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 交易结束时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 平台货品id
		 */
		@ApiField("goods_id")
		private String goodsId;
		/**
		 * 平台货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 平台货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 原始子单号
		 */
		@ApiField("oid")
		private String oid;
		/**
		 * 平台id
		 */
		@ApiField("platform_id")
		private Long platformId;
		/**
		 * 单价
		 */
		@ApiField("price")
		private String price;
		/**
		 * 处理状态
		 */
		@ApiField("process_status")
		private Long processStatus;
		/**
		 * 系统原始单明细id
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 退款金额
		 */
		@ApiField("refund_amount")
		private String refundAmount;
		/**
		 * 退款状态
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 分摊后金额
		 */
		@ApiField("share_amount")
		private String shareAmount;
		/**
		 * 分摊优惠
		 */
		@ApiField("share_discount")
		private String shareDiscount;
		/**
		 * 平台规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 平台规格id
		 */
		@ApiField("spec_id")
		private String specId;
		/**
		 * 平台规格名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 平台规格编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 平台状态
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 原始单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 总价
		 */
		@ApiField("total_amount")
		private String totalAmount;
	

	public String getAdjustAmount() {
			return this.adjustAmount;
		}
		public void setAdjustAmount(String adjustAmount) {
			this.adjustAmount = adjustAmount;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public String getGoodsId() {
			return this.goodsId;
		}
		public void setGoodsId(String goodsId) {
			this.goodsId = goodsId;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getOid() {
			return this.oid;
		}
		public void setOid(String oid) {
			this.oid = oid;
		}
		public Long getPlatformId() {
			return this.platformId;
		}
		public void setPlatformId(Long platformId) {
			this.platformId = platformId;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public Long getProcessStatus() {
			return this.processStatus;
		}
		public void setProcessStatus(Long processStatus) {
			this.processStatus = processStatus;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getRefundAmount() {
			return this.refundAmount;
		}
		public void setRefundAmount(String refundAmount) {
			this.refundAmount = refundAmount;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getShareAmount() {
			return this.shareAmount;
		}
		public void setShareAmount(String shareAmount) {
			this.shareAmount = shareAmount;
		}
		public String getShareDiscount() {
			return this.shareDiscount;
		}
		public void setShareDiscount(String shareDiscount) {
			this.shareDiscount = shareDiscount;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public String getSpecId() {
			return this.specId;
		}
		public void setSpecId(String specId) {
			this.specId = specId;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(String totalAmount) {
			this.totalAmount = totalAmount;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 原因
		 */
		@ApiField("bad_reason")
		private String badReason;
		/**
		 * 买家区域
		 */
		@ApiField("buyer_area")
		private String buyerArea;
		/**
		 * 邮箱
		 */
		@ApiField("buyer_email")
		private String buyerEmail;
		/**
		 * 买家留言
		 */
		@ApiField("buyer_message")
		private String buyerMessage;
		/**
		 * 买家姓名
		 */
		@ApiField("buyer_name")
		private String buyerName;
		/**
		 * 买家昵称
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 给消费者开票金额
		 */
		@ApiField("consumer_amount")
		private String consumerAmount;
		/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 币种
		 */
		@ApiField("currency")
		private String currency;
		/**
		 * 发货条件（1:款到发货 2:货到付款(包含部分货到付款) 3:分期付款）
		 */
		@ApiField("delivery_term")
		private Long deliveryTerm;
		/**
		 * 优惠
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 优惠明细
		 */
		@ApiListField("discount_list")
		@ApiField("discountList")
		private List<DiscountList> discountList;
		/**
		 * 交易结束时间
		 */
		@ApiField("end_time")
		private String endTime;
		/**
		 * 货款
		 */
		@ApiField("goods_amount")
		private String goodsAmount;
		/**
		 * 货品数量
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 担保方式（1:担保交易 2:非担保交易 3:非担保在线交易（ecshop））
		 */
		@ApiField("guarantee_mode")
		private Long guaranteeMode;
		/**
		 * 是否自动流转
		 */
		@ApiField("is_auto_wms")
		private Boolean isAutoWms;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * oaid
		 */
		@ApiField("oaid")
		private String oaid;
		/**
		 * 子单数量
		 */
		@ApiField("order_count")
		private String orderCount;
		/**
		 * 其他收费
		 */
		@ApiField("other_amount")
		private String otherAmount;
		/**
		 * 买家已付金额
		 */
		@ApiField("paid")
		private String paid;
		/**
		 * 买家支付账号
		 */
		@ApiField("pay_account")
		private String payAccount;
		/**
		 * 平台支付单号
		 */
		@ApiField("pay_id")
		private String payId;
		/**
		 * 支付方式（1:在线转账 2:现金 3:银行转账 4:邮局汇款 5:预付款6:刷卡）
		 */
		@ApiField("pay_method")
		private Long payMethod;
		/**
		 * 支付状态（0:未付款 1:部分付款2:已付款）
		 */
		@ApiField("pay_status")
		private Long payStatus;
		/**
		 * 支付时间
		 */
		@ApiField("pay_time")
		private String payTime;
		/**
		 * 给平台开票金额
		 */
		@ApiField("platform_amount")
		private String platformAmount;
		/**
		 * 平台费用
		 */
		@ApiField("platform_cost")
		private String platformCost;
		/**
		 * 平台id
		 */
		@ApiField("platform_id")
		private Long platformId;
		/**
		 * 邮费
		 */
		@ApiField("post_amount")
		private String postAmount;
		/**
		 * 处理状态（10:待递交 15:部分发货待递交 20:已递交 30:部分发货 40:已发货 60:已完成70:已取消）
		 */
		@ApiField("process_status")
		private Long processStatus;
		/**
		 * 唯一键
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 应收
		 */
		@ApiField("receivable")
		private String receivable;
		/**
		 * 已收
		 */
		@ApiField("received")
		private String received;
		/**
		 * 收件人地址
		 */
		@ApiField("receiver_address")
		private String receiverAddress;
		/**
		 * 收件人省市区
		 */
		@ApiField("receiver_area")
		private String receiverArea;
		/**
		 * 收件人城市
		 */
		@ApiField("receiver_city")
		private Long receiverCity;
		/**
		 * 收件人国家
		 */
		@ApiField("receiver_country")
		private Long receiverCountry;
		/**
		 * 收件人区县
		 */
		@ApiField("receiver_district")
		private Long receiverDistrict;
		/**
		 * 收件人手机
		 */
		@ApiField("receiver_mobile")
		private String receiverMobile;
		/**
		 * 收件人姓名
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 收件人省份
		 */
		@ApiField("receiver_province")
		private Long receiverProvince;
		/**
		 * 区域（京东几环）
		 */
		@ApiField("receiver_ring")
		private String receiverRing;
		/**
		 * 收件人电话
		 */
		@ApiField("receiver_telno")
		private String receiverTelno;
		/**
		 * 退款状态（Y	0:无退款 1:取消退款 2:已申请退款 3:等待退货 4:等待收货 5:退款成功6:未付款关闭）
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 客服备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 店铺id
		 */
		@ApiField("shop_id")
		private Long shopId;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_no")
		private String shopNo;
		/**
		 * 原始单号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 送货时间
		 */
		@ApiField("to_deliver_time")
		private String toDeliverTime;
		/**
		 * 原始单明细
		 */
		@ApiListField("trade_orders")
		@ApiField("tradeOrders")
		private List<TradeOrders> tradeOrders;
		/**
		 * 平台状态（10:未确认 20:待尾款 30:待发货 40:部分发货 50:已发货 60:已签收 70:已完成 80:已退款90:已关闭）
		 */
		@ApiField("trade_status")
		private Long tradeStatus;
		/**
		 * 下单时间
		 */
		@ApiField("trade_time")
		private String tradeTime;
		/**
		 * 拼接名称
		 */
		@ApiField("union_name")
		private String unionName;
		/**
		 * 外部仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getBadReason() {
			return this.badReason;
		}
		public void setBadReason(String badReason) {
			this.badReason = badReason;
		}
		public String getBuyerArea() {
			return this.buyerArea;
		}
		public void setBuyerArea(String buyerArea) {
			this.buyerArea = buyerArea;
		}
		public String getBuyerEmail() {
			return this.buyerEmail;
		}
		public void setBuyerEmail(String buyerEmail) {
			this.buyerEmail = buyerEmail;
		}
		public String getBuyerMessage() {
			return this.buyerMessage;
		}
		public void setBuyerMessage(String buyerMessage) {
			this.buyerMessage = buyerMessage;
		}
		public String getBuyerName() {
			return this.buyerName;
		}
		public void setBuyerName(String buyerName) {
			this.buyerName = buyerName;
		}
		public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public String getConsumerAmount() {
			return this.consumerAmount;
		}
		public void setConsumerAmount(String consumerAmount) {
			this.consumerAmount = consumerAmount;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public String getCurrency() {
			return this.currency;
		}
		public void setCurrency(String currency) {
			this.currency = currency;
		}
		public Long getDeliveryTerm() {
			return this.deliveryTerm;
		}
		public void setDeliveryTerm(Long deliveryTerm) {
			this.deliveryTerm = deliveryTerm;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public List<DiscountList> getDiscountList() {
			return this.discountList;
		}
		public void setDiscountList(List<DiscountList> discountList) {
			this.discountList = discountList;
		}
		public String getEndTime() {
			return this.endTime;
		}
		public void setEndTime(String endTime) {
			this.endTime = endTime;
		}
		public String getGoodsAmount() {
			return this.goodsAmount;
		}
		public void setGoodsAmount(String goodsAmount) {
			this.goodsAmount = goodsAmount;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public Long getGuaranteeMode() {
			return this.guaranteeMode;
		}
		public void setGuaranteeMode(Long guaranteeMode) {
			this.guaranteeMode = guaranteeMode;
		}
		public Boolean getIsAutoWms() {
			return this.isAutoWms;
		}
		public void setIsAutoWms(Boolean isAutoWms) {
			this.isAutoWms = isAutoWms;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getOaid() {
			return this.oaid;
		}
		public void setOaid(String oaid) {
			this.oaid = oaid;
		}
		public String getOrderCount() {
			return this.orderCount;
		}
		public void setOrderCount(String orderCount) {
			this.orderCount = orderCount;
		}
		public String getOtherAmount() {
			return this.otherAmount;
		}
		public void setOtherAmount(String otherAmount) {
			this.otherAmount = otherAmount;
		}
		public String getPaid() {
			return this.paid;
		}
		public void setPaid(String paid) {
			this.paid = paid;
		}
		public String getPayAccount() {
			return this.payAccount;
		}
		public void setPayAccount(String payAccount) {
			this.payAccount = payAccount;
		}
		public String getPayId() {
			return this.payId;
		}
		public void setPayId(String payId) {
			this.payId = payId;
		}
		public Long getPayMethod() {
			return this.payMethod;
		}
		public void setPayMethod(Long payMethod) {
			this.payMethod = payMethod;
		}
		public Long getPayStatus() {
			return this.payStatus;
		}
		public void setPayStatus(Long payStatus) {
			this.payStatus = payStatus;
		}
		public String getPayTime() {
			return this.payTime;
		}
		public void setPayTime(String payTime) {
			this.payTime = payTime;
		}
		public String getPlatformAmount() {
			return this.platformAmount;
		}
		public void setPlatformAmount(String platformAmount) {
			this.platformAmount = platformAmount;
		}
		public String getPlatformCost() {
			return this.platformCost;
		}
		public void setPlatformCost(String platformCost) {
			this.platformCost = platformCost;
		}
		public Long getPlatformId() {
			return this.platformId;
		}
		public void setPlatformId(Long platformId) {
			this.platformId = platformId;
		}
		public String getPostAmount() {
			return this.postAmount;
		}
		public void setPostAmount(String postAmount) {
			this.postAmount = postAmount;
		}
		public Long getProcessStatus() {
			return this.processStatus;
		}
		public void setProcessStatus(Long processStatus) {
			this.processStatus = processStatus;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getReceivable() {
			return this.receivable;
		}
		public void setReceivable(String receivable) {
			this.receivable = receivable;
		}
		public String getReceived() {
			return this.received;
		}
		public void setReceived(String received) {
			this.received = received;
		}
		public String getReceiverAddress() {
			return this.receiverAddress;
		}
		public void setReceiverAddress(String receiverAddress) {
			this.receiverAddress = receiverAddress;
		}
		public String getReceiverArea() {
			return this.receiverArea;
		}
		public void setReceiverArea(String receiverArea) {
			this.receiverArea = receiverArea;
		}
		public Long getReceiverCity() {
			return this.receiverCity;
		}
		public void setReceiverCity(Long receiverCity) {
			this.receiverCity = receiverCity;
		}
		public Long getReceiverCountry() {
			return this.receiverCountry;
		}
		public void setReceiverCountry(Long receiverCountry) {
			this.receiverCountry = receiverCountry;
		}
		public Long getReceiverDistrict() {
			return this.receiverDistrict;
		}
		public void setReceiverDistrict(Long receiverDistrict) {
			this.receiverDistrict = receiverDistrict;
		}
		public String getReceiverMobile() {
			return this.receiverMobile;
		}
		public void setReceiverMobile(String receiverMobile) {
			this.receiverMobile = receiverMobile;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public Long getReceiverProvince() {
			return this.receiverProvince;
		}
		public void setReceiverProvince(Long receiverProvince) {
			this.receiverProvince = receiverProvince;
		}
		public String getReceiverRing() {
			return this.receiverRing;
		}
		public void setReceiverRing(String receiverRing) {
			this.receiverRing = receiverRing;
		}
		public String getReceiverTelno() {
			return this.receiverTelno;
		}
		public void setReceiverTelno(String receiverTelno) {
			this.receiverTelno = receiverTelno;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public Long getShopId() {
			return this.shopId;
		}
		public void setShopId(Long shopId) {
			this.shopId = shopId;
		}
		public String getShopNo() {
			return this.shopNo;
		}
		public void setShopNo(String shopNo) {
			this.shopNo = shopNo;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getToDeliverTime() {
			return this.toDeliverTime;
		}
		public void setToDeliverTime(String toDeliverTime) {
			this.toDeliverTime = toDeliverTime;
		}
		public List<TradeOrders> getTradeOrders() {
			return this.tradeOrders;
		}
		public void setTradeOrders(List<TradeOrders> tradeOrders) {
			this.tradeOrders = tradeOrders;
		}
		public Long getTradeStatus() {
			return this.tradeStatus;
		}
		public void setTradeStatus(Long tradeStatus) {
			this.tradeStatus = tradeStatus;
		}
		public String getTradeTime() {
			return this.tradeTime;
		}
		public void setTradeTime(String tradeTime) {
			this.tradeTime = tradeTime;
		}
		public String getUnionName() {
			return this.unionName;
		}
		public void setUnionName(String unionName) {
			this.unionName = unionName;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据数据
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 总条数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
