package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockout.sales.querywithdetail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtWmsStockoutSalesQuerywithdetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5384946196126421274L;

	/** 
	 * 出库单信息
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 货位明细列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class PositionDetailsList {

	/**
		 * 批次号
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 货位数量
		 */
		@ApiField("position_goods_count")
		private String positionGoodsCount;
		/**
		 * 货位id
		 */
		@ApiField("position_id")
		private Long positionId;
		/**
		 * 货位编号
		 */
		@ApiField("position_no")
		private String positionNo;
		/**
		 * 货位明细id
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 销售出库单明细id
		 */
		@ApiField("stockout_detail_id")
		private Long stockoutDetailId;
	

	public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getPositionGoodsCount() {
			return this.positionGoodsCount;
		}
		public void setPositionGoodsCount(String positionGoodsCount) {
			this.positionGoodsCount = positionGoodsCount;
		}
		public Long getPositionId() {
			return this.positionId;
		}
		public void setPositionId(Long positionId) {
			this.positionId = positionId;
		}
		public String getPositionNo() {
			return this.positionNo;
		}
		public void setPositionNo(String positionNo) {
			this.positionNo = positionNo;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public Long getStockoutDetailId() {
			return this.stockoutDetailId;
		}
		public void setStockoutDetailId(Long stockoutDetailId) {
			this.stockoutDetailId = stockoutDetailId;
		}

}

	/**
 * 销售出库单详情
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailsList {

	/**
		 * 主条码
		 */
		@ApiField("barcode")
		private String barcode;
		/**
		 * 基本单位
		 */
		@ApiField("base_unit_id")
		private Long baseUnitId;
		/**
		 * 指定出库批次
		 */
		@ApiField("batch_id")
		private Long batchId;
		/**
		 * 品牌名称
		 */
		@ApiField("brand_name")
		private String brandName;
		/**
		 * 品牌编号
		 */
		@ApiField("brand_no")
		private String brandNo;
		/**
		 * 成本价:  平均成本如果为空或者小于0,就是计划成本
		 */
		@ApiField("cost_price")
		private String costPrice;
		/**
		 * 创建时间
		 */
		@ApiField("created_date")
		private String createdDate;
		/**
		 * 总折扣金额
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 订单内部来源:  1手机 2聚划算
		 */
		@ApiField("from_mask")
		private Long fromMask;
		/**
		 * 是否是赠品:  0非赠品  1自动赠送  2手工赠送
		 */
		@ApiField("gift_type")
		private Long giftType;
		/**
		 * 货品自定义属性1
		 */
		@ApiField("good_prop1")
		private String goodProp1;
		/**
		 * 货品自定义属性2
		 */
		@ApiField("good_prop2")
		private String goodProp2;
		/**
		 * 货品自定义属性3
		 */
		@ApiField("good_prop3")
		private String goodProp3;
		/**
		 * 货品自定义属性4
		 */
		@ApiField("good_prop4")
		private String goodProp4;
		/**
		 * 货品自定义属性5
		 */
		@ApiField("good_prop5")
		private String goodProp5;
		/**
		 * 货品自定义属性6
		 */
		@ApiField("good_prop6")
		private String goodProp6;
		/**
		 * 货品总额
		 */
		@ApiField("goods_amount")
		private String goodsAmount;
		/**
		 * 货品数量:  如果按照货位分组就是总货品数量
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 货品id
		 */
		@ApiField("goods_id")
		private Long goodsId;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编码
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 货品类型:  1销售商品  2原材料  3包装  4周转材料 5虚拟商品 6固定资产  0其它
		 */
		@ApiField("goods_type")
		private Long goodsType;
		/**
		 * 是否验货
		 */
		@ApiField("is_examined")
		private Long isExamined;
		/**
		 * 是否包装
		 */
		@ApiField("is_package")
		private Boolean isPackage;
		/**
		 * 销售单价:  手工新建时使用货品属性中的“零售价”
		 */
		@ApiField("market_price")
		private String marketPrice;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified_date")
		private String modifiedDate;
		/**
		 * 货品数量
		 */
		@ApiField("num")
		private String num;
		/**
		 * 辅助数量
		 */
		@ApiField("num2")
		private String num2;
		/**
		 * 已支付金额:  如果按照货位分组就是总的已经支付的金额
		 */
		@ApiField("paid")
		private String paid;
		/**
		 * 平台ID
		 */
		@ApiField("platform_id")
		private Long platformId;
		/**
		 * 货位明细列表
		 */
		@ApiListField("position_details_list")
		@ApiField("positionDetailsList")
		private List<PositionDetailsList> positionDetailsList;
		/**
		 * 出库货位id
		 */
		@ApiField("position_id")
		private Long positionId;
		/**
		 * 规格自定义属性1
		 */
		@ApiField("prop1")
		private String prop1;
		/**
		 * 规格自定义属性2
		 */
		@ApiField("prop2")
		private String prop2;
		/**
		 * 规格自定义属性3
		 */
		@ApiField("prop3")
		private String prop3;
		/**
		 * 规格自定义属性4
		 */
		@ApiField("prop4")
		private String prop4;
		/**
		 * 规格自定义属性5
		 */
		@ApiField("prop5")
		private String prop5;
		/**
		 * 规格自定义属性6
		 */
		@ApiField("prop6")
		private String prop6;
		/**
		 * 销售出库单详情的id
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 退款状态:  0无退款 1取消退款, 2已申请退款 3等待退货 4等待收货 5退款成功---(原始子订单关闭，这里也是退款状态)
		 */
		@ApiField("refund_status")
		private String refundStatus;
		/**
		 * 出库单明细备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 订单货品(子订单)id
		 */
		@ApiField("sale_order_id")
		private Long saleOrderId;
		/**
		 * 扫描方式
		 */
		@ApiField("scan_type")
		private Long scanType;
		/**
		 * 成交价
		 */
		@ApiField("sell_price")
		private String sellPrice;
		/**
		 * 分摊后合计应收
		 */
		@ApiField("share_amount")
		private String shareAmount;
		/**
		 * 分摊邮费
		 */
		@ApiField("share_post_amount")
		private String sharePostAmount;
		/**
		 * 货品成交价（同销售出库单明细界面的货品成交价）
		 */
		@ApiField("share_price")
		private String sharePrice;
		/**
		 * 如果need_sn=false, 返回空字符串;否则返回英文逗号拼接的sn
		 */
		@ApiField("sn_list")
		private String snList;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 规格id
		 */
		@ApiField("spec_id")
		private Long specId;
		/**
		 * 规格名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 原始子订单号
		 */
		@ApiField("src_oid")
		private String srcOid;
		/**
		 * 订单明细id
		 */
		@ApiField("src_order_detail_id")
		private Long srcOrderDetailId;
		/**
		 * 源单据类别
		 */
		@ApiField("src_order_type")
		private Long srcOrderType;
		/**
		 * 原始订单号
		 */
		@ApiField("src_tid")
		private String srcTid;
		/**
		 * 出库单id
		 */
		@ApiField("stockout_id")
		private Long stockoutId;
		/**
		 * 组合装编号
		 */
		@ApiField("suite_no")
		private String suiteNo;
		/**
		 * 税率
		 */
		@ApiField("tax_rate")
		private String taxRate;
		/**
		 * 总成本:  如果平均成本为空或者小于0,就使用计划成本; 如果按照货位分组就是总成本
		 */
		@ApiField("total_amount")
		private String totalAmount;
		/**
		 * 辅助单位
		 */
		@ApiField("unit_id")
		private Long unitId;
		/**
		 * 单位名称
		 */
		@ApiField("unit_name")
		private String unitName;
		/**
		 * 单位换算
		 */
		@ApiField("unit_ratio")
		private String unitRatio;
		/**
		 * 总重量
		 */
		@ApiField("weight")
		private String weight;
	

	public String getBarcode() {
			return this.barcode;
		}
		public void setBarcode(String barcode) {
			this.barcode = barcode;
		}
		public Long getBaseUnitId() {
			return this.baseUnitId;
		}
		public void setBaseUnitId(Long baseUnitId) {
			this.baseUnitId = baseUnitId;
		}
		public Long getBatchId() {
			return this.batchId;
		}
		public void setBatchId(Long batchId) {
			this.batchId = batchId;
		}
		public String getBrandName() {
			return this.brandName;
		}
		public void setBrandName(String brandName) {
			this.brandName = brandName;
		}
		public String getBrandNo() {
			return this.brandNo;
		}
		public void setBrandNo(String brandNo) {
			this.brandNo = brandNo;
		}
		public String getCostPrice() {
			return this.costPrice;
		}
		public void setCostPrice(String costPrice) {
			this.costPrice = costPrice;
		}
		public String getCreatedDate() {
			return this.createdDate;
		}
		public void setCreatedDate(String createdDate) {
			this.createdDate = createdDate;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public Long getFromMask() {
			return this.fromMask;
		}
		public void setFromMask(Long fromMask) {
			this.fromMask = fromMask;
		}
		public Long getGiftType() {
			return this.giftType;
		}
		public void setGiftType(Long giftType) {
			this.giftType = giftType;
		}
		public String getGoodProp1() {
			return this.goodProp1;
		}
		public void setGoodProp1(String goodProp1) {
			this.goodProp1 = goodProp1;
		}
		public String getGoodProp2() {
			return this.goodProp2;
		}
		public void setGoodProp2(String goodProp2) {
			this.goodProp2 = goodProp2;
		}
		public String getGoodProp3() {
			return this.goodProp3;
		}
		public void setGoodProp3(String goodProp3) {
			this.goodProp3 = goodProp3;
		}
		public String getGoodProp4() {
			return this.goodProp4;
		}
		public void setGoodProp4(String goodProp4) {
			this.goodProp4 = goodProp4;
		}
		public String getGoodProp5() {
			return this.goodProp5;
		}
		public void setGoodProp5(String goodProp5) {
			this.goodProp5 = goodProp5;
		}
		public String getGoodProp6() {
			return this.goodProp6;
		}
		public void setGoodProp6(String goodProp6) {
			this.goodProp6 = goodProp6;
		}
		public String getGoodsAmount() {
			return this.goodsAmount;
		}
		public void setGoodsAmount(String goodsAmount) {
			this.goodsAmount = goodsAmount;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public Long getGoodsId() {
			return this.goodsId;
		}
		public void setGoodsId(Long goodsId) {
			this.goodsId = goodsId;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public Long getGoodsType() {
			return this.goodsType;
		}
		public void setGoodsType(Long goodsType) {
			this.goodsType = goodsType;
		}
		public Long getIsExamined() {
			return this.isExamined;
		}
		public void setIsExamined(Long isExamined) {
			this.isExamined = isExamined;
		}
		public Boolean getIsPackage() {
			return this.isPackage;
		}
		public void setIsPackage(Boolean isPackage) {
			this.isPackage = isPackage;
		}
		public String getMarketPrice() {
			return this.marketPrice;
		}
		public void setMarketPrice(String marketPrice) {
			this.marketPrice = marketPrice;
		}
		public String getModifiedDate() {
			return this.modifiedDate;
		}
		public void setModifiedDate(String modifiedDate) {
			this.modifiedDate = modifiedDate;
		}
		public String getNum() {
			return this.num;
		}
		public void setNum(String num) {
			this.num = num;
		}
		public String getNum2() {
			return this.num2;
		}
		public void setNum2(String num2) {
			this.num2 = num2;
		}
		public String getPaid() {
			return this.paid;
		}
		public void setPaid(String paid) {
			this.paid = paid;
		}
		public Long getPlatformId() {
			return this.platformId;
		}
		public void setPlatformId(Long platformId) {
			this.platformId = platformId;
		}
		public List<PositionDetailsList> getPositionDetailsList() {
			return this.positionDetailsList;
		}
		public void setPositionDetailsList(List<PositionDetailsList> positionDetailsList) {
			this.positionDetailsList = positionDetailsList;
		}
		public Long getPositionId() {
			return this.positionId;
		}
		public void setPositionId(Long positionId) {
			this.positionId = positionId;
		}
		public String getProp1() {
			return this.prop1;
		}
		public void setProp1(String prop1) {
			this.prop1 = prop1;
		}
		public String getProp2() {
			return this.prop2;
		}
		public void setProp2(String prop2) {
			this.prop2 = prop2;
		}
		public String getProp3() {
			return this.prop3;
		}
		public void setProp3(String prop3) {
			this.prop3 = prop3;
		}
		public String getProp4() {
			return this.prop4;
		}
		public void setProp4(String prop4) {
			this.prop4 = prop4;
		}
		public String getProp5() {
			return this.prop5;
		}
		public void setProp5(String prop5) {
			this.prop5 = prop5;
		}
		public String getProp6() {
			return this.prop6;
		}
		public void setProp6(String prop6) {
			this.prop6 = prop6;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(String refundStatus) {
			this.refundStatus = refundStatus;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public Long getSaleOrderId() {
			return this.saleOrderId;
		}
		public void setSaleOrderId(Long saleOrderId) {
			this.saleOrderId = saleOrderId;
		}
		public Long getScanType() {
			return this.scanType;
		}
		public void setScanType(Long scanType) {
			this.scanType = scanType;
		}
		public String getSellPrice() {
			return this.sellPrice;
		}
		public void setSellPrice(String sellPrice) {
			this.sellPrice = sellPrice;
		}
		public String getShareAmount() {
			return this.shareAmount;
		}
		public void setShareAmount(String shareAmount) {
			this.shareAmount = shareAmount;
		}
		public String getSharePostAmount() {
			return this.sharePostAmount;
		}
		public void setSharePostAmount(String sharePostAmount) {
			this.sharePostAmount = sharePostAmount;
		}
		public String getSharePrice() {
			return this.sharePrice;
		}
		public void setSharePrice(String sharePrice) {
			this.sharePrice = sharePrice;
		}
		public String getSnList() {
			return this.snList;
		}
		public void setSnList(String snList) {
			this.snList = snList;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public Long getSpecId() {
			return this.specId;
		}
		public void setSpecId(Long specId) {
			this.specId = specId;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getSrcOid() {
			return this.srcOid;
		}
		public void setSrcOid(String srcOid) {
			this.srcOid = srcOid;
		}
		public Long getSrcOrderDetailId() {
			return this.srcOrderDetailId;
		}
		public void setSrcOrderDetailId(Long srcOrderDetailId) {
			this.srcOrderDetailId = srcOrderDetailId;
		}
		public Long getSrcOrderType() {
			return this.srcOrderType;
		}
		public void setSrcOrderType(Long srcOrderType) {
			this.srcOrderType = srcOrderType;
		}
		public String getSrcTid() {
			return this.srcTid;
		}
		public void setSrcTid(String srcTid) {
			this.srcTid = srcTid;
		}
		public Long getStockoutId() {
			return this.stockoutId;
		}
		public void setStockoutId(Long stockoutId) {
			this.stockoutId = stockoutId;
		}
		public String getSuiteNo() {
			return this.suiteNo;
		}
		public void setSuiteNo(String suiteNo) {
			this.suiteNo = suiteNo;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}
		public String getTotalAmount() {
			return this.totalAmount;
		}
		public void setTotalAmount(String totalAmount) {
			this.totalAmount = totalAmount;
		}
		public Long getUnitId() {
			return this.unitId;
		}
		public void setUnitId(Long unitId) {
			this.unitId = unitId;
		}
		public String getUnitName() {
			return this.unitName;
		}
		public void setUnitName(String unitName) {
			this.unitName = unitName;
		}
		public String getUnitRatio() {
			return this.unitRatio;
		}
		public void setUnitRatio(String unitRatio) {
			this.unitRatio = unitRatio;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}

}

	/**
 * 物流信息列表
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Logisticslist {

	/**
		 * 估算重量
		 */
		@ApiField("calc_weight")
		private String calcWeight;
		/**
		 * 高
		 */
		@ApiField("height")
		private String height;
		/**
		 * 长
		 */
		@ApiField("length")
		private String length;
		/**
		 * 物流id
		 */
		@ApiField("logistics_id")
		private Long logisticsId;
		/**
		 * 物流名称
		 */
		@ApiField("logistics_name")
		private String logisticsName;
		/**
		 * 物流单号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 包装
		 */
		@ApiField("package_name")
		private String packageName;
		/**
		 * 邮资
		 */
		@ApiField("postage")
		private String postage;
		/**
		 * 物流单id
		 */
		@ApiField("rec_id")
		private Long recId;
		/**
		 * 备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 出库单id
		 */
		@ApiField("stockout_id")
		private Long stockoutId;
		/**
		 * 体积
		 */
		@ApiField("volume")
		private String volume;
		/**
		 * 称重重量
		 */
		@ApiField("weight")
		private String weight;
		/**
		 * 宽
		 */
		@ApiField("width")
		private String width;
	

	public String getCalcWeight() {
			return this.calcWeight;
		}
		public void setCalcWeight(String calcWeight) {
			this.calcWeight = calcWeight;
		}
		public String getHeight() {
			return this.height;
		}
		public void setHeight(String height) {
			this.height = height;
		}
		public String getLength() {
			return this.length;
		}
		public void setLength(String length) {
			this.length = length;
		}
		public Long getLogisticsId() {
			return this.logisticsId;
		}
		public void setLogisticsId(Long logisticsId) {
			this.logisticsId = logisticsId;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public String getPackageName() {
			return this.packageName;
		}
		public void setPackageName(String packageName) {
			this.packageName = packageName;
		}
		public String getPostage() {
			return this.postage;
		}
		public void setPostage(String postage) {
			this.postage = postage;
		}
		public Long getRecId() {
			return this.recId;
		}
		public void setRecId(Long recId) {
			this.recId = recId;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public Long getStockoutId() {
			return this.stockoutId;
		}
		public void setStockoutId(Long stockoutId) {
			this.stockoutId = stockoutId;
		}
		public String getVolume() {
			return this.volume;
		}
		public void setVolume(String volume) {
			this.volume = volume;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}
		public String getWidth() {
			return this.width;
		}
		public void setWidth(String width) {
			this.width = width;
		}

}

	/**
 * 单据数据
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 异常原因:   0正常 1无库存记录  2地址发生变化  4发票变化 8仓库变化 16备注变化 32平台更换货品 64退款
		 */
		@ApiField("bad_reason")
		private Long badReason;
		/**
		 * 打印批次
		 */
		@ApiField("batch_no")
		private String batchNo;
		/**
		 * 截停原因:  0正常 1申请退款 2已退款 4地址被修改 8发票被修改 16物流被修改 32仓库变化 64备注修改 128更换货品 256取消退款
		 */
		@ApiField("block_reason")
		private Long blockReason;
		/**
		 * 买家备注
		 */
		@ApiField("buyer_message")
		private String buyerMessage;
		/**
		 * 预估邮费成本
		 */
		@ApiField("calc_post_cost")
		private String calcPostCost;
		/**
		 * 货到付款金额
		 */
		@ApiField("cod_amount")
		private String codAmount;
		/**
		 * 出库状态
		 */
		@ApiField("consign_status")
		private Long consignStatus;
		/**
		 * 出库时间
		 */
		@ApiField("consign_time")
		private String consignTime;
		/**
		 * 发货员
		 */
		@ApiField("consigner_name")
		private String consignerName;
		/**
		 * 建单时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 创建时间
		 */
		@ApiField("created_date")
		private String createdDate;
		/**
		 * 客服备注
		 */
		@ApiField("cs_remark")
		private String csRemark;
		/**
		 * 币种
		 */
		@ApiField("currency")
		private String currency;
		/**
		 * 其他出库自定义子类别
		 */
		@ApiField("custom_type")
		private Long customType;
		/**
		 * 客户id
		 */
		@ApiField("customer_id")
		private Long customerId;
		/**
		 * 客户姓名
		 */
		@ApiField("customer_name")
		private String customerName;
		/**
		 * 客户编码
		 */
		@ApiField("customer_no")
		private String customerNo;
		/**
		 * 发货条件:  1款到发货  2货到付款(包含部分货到付款)  3分期付款
		 */
		@ApiField("delivery_term")
		private Long deliveryTerm;
		/**
		 * 销售出库单详情
		 */
		@ApiListField("details_list")
		@ApiField("detailsList")
		private List<DetailsList> detailsList;
		/**
		 * 优惠金额
		 */
		@ApiField("discount")
		private String discount;
		/**
		 * 业务员编号
		 */
		@ApiField("employee_no")
		private String employeeNo;
		/**
		 * 接口处理错误信息
		 */
		@ApiField("error_info")
		private String errorInfo;
		/**
		 * 验货员
		 */
		@ApiField("examiner_name")
		private String examinerName;
		/**
		 * 分销商
		 */
		@ApiField("fenxiao_nick")
		private String fenxiaoNick;
		/**
		 * 分销商编码
		 */
		@ApiField("fenxiao_nick_no")
		private String fenxiaoNickNo;
		/**
		 * 分销原始单号
		 */
		@ApiField("fenxiao_tid")
		private String fenxiaoTid;
		/**
		 * 标记名称
		 */
		@ApiField("flag_name")
		private String flagName;
		/**
		 * 审核员姓名
		 */
		@ApiField("fullname")
		private String fullname;
		/**
		 * 货品数量
		 */
		@ApiField("goods_count")
		private String goodsCount;
		/**
		 * 总货款
		 */
		@ApiField("goods_total_amount")
		private String goodsTotalAmount;
		/**
		 * 总成本价,所有明细cost_price*goods_count的和
		 */
		@ApiField("goods_total_cost")
		private String goodsTotalCost;
		/**
		 * 货品种类数量
		 */
		@ApiField("goods_type_count")
		private Long goodsTypeCount;
		/**
		 * 证件号码
		 */
		@ApiField("id_card")
		private String idCard;
		/**
		 * 证件类别
		 */
		@ApiField("id_card_type")
		private Long idCardType;
		/**
		 * 发票内容
		 */
		@ApiField("invoice_content")
		private String invoiceContent;
		/**
		 * 发票id:  目前只设0-1， 1表示已开发票
		 */
		@ApiField("invoice_id")
		private Long invoiceId;
		/**
		 * 发票标题
		 */
		@ApiField("invoice_title")
		private String invoiceTitle;
		/**
		 * 发票类别:  0不需要 1普通发票 2增值税发票
		 */
		@ApiField("invoice_type")
		private Long invoiceType;
		/**
		 * 物流编号
		 */
		@ApiField("logistics_code")
		private String logisticsCode;
		/**
		 * 物流id
		 */
		@ApiField("logistics_id")
		private Long logisticsId;
		/**
		 * 物流信息列表
		 */
		@ApiListField("logistics_list")
		@ApiField("logisticslist")
		private List<Logisticslist> logisticsList;
		/**
		 * 物流公司名称
		 */
		@ApiField("logistics_name")
		private String logisticsName;
		/**
		 * 物流单编号
		 */
		@ApiField("logistics_no")
		private String logisticsNo;
		/**
		 * 物流单打印状态
		 */
		@ApiField("logistics_print_status")
		private Long logisticsPrintStatus;
		/**
		 * 物流方式
		 */
		@ApiField("logistics_type")
		private Long logisticsType;
		/**
		 * 最后修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 买家昵称
		 */
		@ApiField("nick_name")
		private String nickName;
		/**
		 * 制单人
		 */
		@ApiField("operator_id")
		private Long operatorId;
		/**
		 * 出库单号
		 */
		@ApiField("order_no")
		private String orderNo;
		/**
		 * 源单据类别(1销售订单 2调拨出库 3采购退货出库 4盘亏出库 5生产出库 6现款销售出库 7其他出库)
		 */
		@ApiField("order_type")
		private Long orderType;
		/**
		 * 外部单号
		 */
		@ApiField("outer_no")
		private String outerNo;
		/**
		 * 包装成本(使用包装的计划成本)
		 */
		@ApiField("package_fee")
		private String packageFee;
		/**
		 * 打包员
		 */
		@ApiField("packager_name")
		private String packagerName;
		/**
		 * 已支付金额
		 */
		@ApiField("paid")
		private String paid;
		/**
		 * 支付时间
		 */
		@ApiField("pay_time")
		private String payTime;
		/**
		 * 拣货员
		 */
		@ApiField("picker_name")
		private String pickerName;
		/**
		 * 分拣波次编号
		 */
		@ApiField("picklist_no")
		private String picklistNo;
		/**
		 * 分拣波次序号
		 */
		@ApiField("picklist_seq")
		private Long picklistSeq;
		/**
		 * 平台id
		 */
		@ApiField("platform_id")
		private Long platformId;
		/**
		 * 邮费
		 */
		@ApiField("post_amount")
		private String postAmount;
		/**
		 * 邮费成本:  (使用根据重量预估的邮费)
		 */
		@ApiField("post_fee")
		private String postFee;
		/**
		 * 打印备注
		 */
		@ApiField("print_remark")
		private String printRemark;
		/**
		 * 打单员
		 */
		@ApiField("printer_name")
		private String printerName;
		/**
		 * 已付金额(使用应收金额)
		 */
		@ApiField("receivable")
		private String receivable;
		/**
		 * 收件地址
		 */
		@ApiField("receiver_address")
		private String receiverAddress;
		/**
		 * 省市区空格分隔
		 */
		@ApiField("receiver_area")
		private String receiverArea;
		/**
		 * 城市id
		 */
		@ApiField("receiver_city")
		private Long receiverCity;
		/**
		 * 国家
		 */
		@ApiField("receiver_country")
		private Long receiverCountry;
		/**
		 * 地区id
		 */
		@ApiField("receiver_district")
		private Long receiverDistrict;
		/**
		 * 大头笔
		 */
		@ApiField("receiver_dtb")
		private String receiverDtb;
		/**
		 * 收件人手机
		 */
		@ApiField("receiver_mobile")
		private String receiverMobile;
		/**
		 * 收件人姓名
		 */
		@ApiField("receiver_name")
		private String receiverName;
		/**
		 * 省份id
		 */
		@ApiField("receiver_province")
		private Long receiverProvince;
		/**
		 * 收件人固话
		 */
		@ApiField("receiver_telno")
		private String receiverTelno;
		/**
		 * 收件人邮编
		 */
		@ApiField("receiver_zip")
		private String receiverZip;
		/**
		 * 退款状态:  0无退款 1申请退款  2部分退款  3全部退款
		 */
		@ApiField("refund_status")
		private Long refundStatus;
		/**
		 * 出库单备注
		 */
		@ApiField("remark")
		private String remark;
		/**
		 * 审核员编号
		 */
		@ApiField("salesman_no")
		private String salesmanNo;
		/**
		 * 发货单模板id
		 */
		@ApiField("sendbill_template_id")
		private Long sendbillTemplateId;
		/**
		 * 序号
		 */
		@ApiField("seq_no")
		private Long seqNo;
		/**
		 * 店铺id
		 */
		@ApiField("shop_id")
		private Long shopId;
		/**
		 * 店铺名称
		 */
		@ApiField("shop_name")
		private String shopName;
		/**
		 * 店铺编号
		 */
		@ApiField("shop_no")
		private String shopNo;
		/**
		 * 店铺平台id
		 */
		@ApiField("shop_platform_id")
		private Long shopPlatformId;
		/**
		 * 店铺备注
		 */
		@ApiField("shop_remark")
		private String shopRemark;
		/**
		 * 订单id
		 */
		@ApiField("src_order_id")
		private Long srcOrderId;
		/**
		 * 源单号订单号
		 */
		@ApiField("src_order_no")
		private String srcOrderNo;
		/**
		 * 原始单号:  (如果有多个，以","分隔且以增序排列,不重复,过长将被裁剪)
		 */
		@ApiField("src_trade_no")
		private String srcTradeNo;
		/**
		 * 出库单状态:   5已取消  10待放回(拣货待放回), 小于该值的都是已取消的单子 48 未确认  50待审核 51 缺货无法发货 54 获取面单号 60 待分配,电子面单获取成功后 61 排队中,将出库单加入到队伍中 65待人工处理   75待拣货,创建批次之后 77 拣货中,PDA拣货后 79 已拣货 90延时发货, 到指定时间后会自动发货 95已发货  110已完成 113 异常发货 115 回传失败 120 回传成功
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 出库单建单时间
		 */
		@ApiField("stock_check_time")
		private String stockCheckTime;
		/**
		 * 出库单id
		 */
		@ApiField("stockout_id")
		private Long stockoutId;
		/**
		 * 子平台id
		 */
		@ApiField("sub_platform_id")
		private Long subPlatformId;
		/**
		 * 税额
		 */
		@ApiField("tax")
		private String tax;
		/**
		 * 税率
		 */
		@ApiField("tax_rate")
		private String taxRate;
		/**
		 * 订单来源： 1、API抓单 2、手工建单 3、导入 4、复制订单 5、接口推送 6、补发订单 7、PDA选货开单
		 */
		@ApiField("trade_from")
		private Long tradeFrom;
		/**
		 * 订单id
		 */
		@ApiField("trade_id")
		private Long tradeId;
		/**
		 * 订单标签
		 */
		@ApiField("trade_label")
		private String tradeLabel;
		/**
		 * 订单编号
		 */
		@ApiField("trade_no")
		private String tradeNo;
		/**
		 * 订单状态:   4 线下退款 5已取消  6 待确认订单, 导入放入这个状态  待转预订单(待审核) 7待确认订单,导入时先放到这个状态（此状态不占用库存,可删除,离开这个状态就不能删除了) 10待付款  15等未付 16延时审核  19预订单前处理  20前处理(赠品，合并，拆分) 21委外前处理  23 异常预订单 24 换货预订单 26 待激活预订单 27待分配预订单  30待客审  35待财审  55已确认  95已发货  96 待录入计划成本，订单结算时有货品无计划成本 99 待过账 100已签收  101 已过账 105部分打款  110已完成',
		 */
		@ApiField("trade_status")
		private Long tradeStatus;
		/**
		 * 下单时间
		 */
		@ApiField("trade_time")
		private String tradeTime;
		/**
		 * 销售类型:  1网店销售 2线下零售 3售后换货 4批发业务
		 */
		@ApiField("trade_type")
		private Long tradeType;
		/**
		 * 仓库id
		 */
		@ApiField("warehouse_id")
		private Long warehouseId;
		/**
		 * 实体仓和虚拟仓之间的映射编码（需开通配置设置）
		 */
		@ApiField("warehouse_mapping_code")
		private String warehouseMappingCode;
		/**
		 * 仓库名称
		 */
		@ApiField("warehouse_name")
		private String warehouseName;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
		/**
		 * 仓库类别
		 */
		@ApiField("warehouse_type")
		private Long warehouseType;
		/**
		 * 实际称得重量kg
		 */
		@ApiField("weight")
		private String weight;
	

	public Long getBadReason() {
			return this.badReason;
		}
		public void setBadReason(Long badReason) {
			this.badReason = badReason;
		}
		public String getBatchNo() {
			return this.batchNo;
		}
		public void setBatchNo(String batchNo) {
			this.batchNo = batchNo;
		}
		public Long getBlockReason() {
			return this.blockReason;
		}
		public void setBlockReason(Long blockReason) {
			this.blockReason = blockReason;
		}
		public String getBuyerMessage() {
			return this.buyerMessage;
		}
		public void setBuyerMessage(String buyerMessage) {
			this.buyerMessage = buyerMessage;
		}
		public String getCalcPostCost() {
			return this.calcPostCost;
		}
		public void setCalcPostCost(String calcPostCost) {
			this.calcPostCost = calcPostCost;
		}
		public String getCodAmount() {
			return this.codAmount;
		}
		public void setCodAmount(String codAmount) {
			this.codAmount = codAmount;
		}
		public Long getConsignStatus() {
			return this.consignStatus;
		}
		public void setConsignStatus(Long consignStatus) {
			this.consignStatus = consignStatus;
		}
		public String getConsignTime() {
			return this.consignTime;
		}
		public void setConsignTime(String consignTime) {
			this.consignTime = consignTime;
		}
		public String getConsignerName() {
			return this.consignerName;
		}
		public void setConsignerName(String consignerName) {
			this.consignerName = consignerName;
		}
		public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public String getCreatedDate() {
			return this.createdDate;
		}
		public void setCreatedDate(String createdDate) {
			this.createdDate = createdDate;
		}
		public String getCsRemark() {
			return this.csRemark;
		}
		public void setCsRemark(String csRemark) {
			this.csRemark = csRemark;
		}
		public String getCurrency() {
			return this.currency;
		}
		public void setCurrency(String currency) {
			this.currency = currency;
		}
		public Long getCustomType() {
			return this.customType;
		}
		public void setCustomType(Long customType) {
			this.customType = customType;
		}
		public Long getCustomerId() {
			return this.customerId;
		}
		public void setCustomerId(Long customerId) {
			this.customerId = customerId;
		}
		public String getCustomerName() {
			return this.customerName;
		}
		public void setCustomerName(String customerName) {
			this.customerName = customerName;
		}
		public String getCustomerNo() {
			return this.customerNo;
		}
		public void setCustomerNo(String customerNo) {
			this.customerNo = customerNo;
		}
		public Long getDeliveryTerm() {
			return this.deliveryTerm;
		}
		public void setDeliveryTerm(Long deliveryTerm) {
			this.deliveryTerm = deliveryTerm;
		}
		public List<DetailsList> getDetailsList() {
			return this.detailsList;
		}
		public void setDetailsList(List<DetailsList> detailsList) {
			this.detailsList = detailsList;
		}
		public String getDiscount() {
			return this.discount;
		}
		public void setDiscount(String discount) {
			this.discount = discount;
		}
		public String getEmployeeNo() {
			return this.employeeNo;
		}
		public void setEmployeeNo(String employeeNo) {
			this.employeeNo = employeeNo;
		}
		public String getErrorInfo() {
			return this.errorInfo;
		}
		public void setErrorInfo(String errorInfo) {
			this.errorInfo = errorInfo;
		}
		public String getExaminerName() {
			return this.examinerName;
		}
		public void setExaminerName(String examinerName) {
			this.examinerName = examinerName;
		}
		public String getFenxiaoNick() {
			return this.fenxiaoNick;
		}
		public void setFenxiaoNick(String fenxiaoNick) {
			this.fenxiaoNick = fenxiaoNick;
		}
		public String getFenxiaoNickNo() {
			return this.fenxiaoNickNo;
		}
		public void setFenxiaoNickNo(String fenxiaoNickNo) {
			this.fenxiaoNickNo = fenxiaoNickNo;
		}
		public String getFenxiaoTid() {
			return this.fenxiaoTid;
		}
		public void setFenxiaoTid(String fenxiaoTid) {
			this.fenxiaoTid = fenxiaoTid;
		}
		public String getFlagName() {
			return this.flagName;
		}
		public void setFlagName(String flagName) {
			this.flagName = flagName;
		}
		public String getFullname() {
			return this.fullname;
		}
		public void setFullname(String fullname) {
			this.fullname = fullname;
		}
		public String getGoodsCount() {
			return this.goodsCount;
		}
		public void setGoodsCount(String goodsCount) {
			this.goodsCount = goodsCount;
		}
		public String getGoodsTotalAmount() {
			return this.goodsTotalAmount;
		}
		public void setGoodsTotalAmount(String goodsTotalAmount) {
			this.goodsTotalAmount = goodsTotalAmount;
		}
		public String getGoodsTotalCost() {
			return this.goodsTotalCost;
		}
		public void setGoodsTotalCost(String goodsTotalCost) {
			this.goodsTotalCost = goodsTotalCost;
		}
		public Long getGoodsTypeCount() {
			return this.goodsTypeCount;
		}
		public void setGoodsTypeCount(Long goodsTypeCount) {
			this.goodsTypeCount = goodsTypeCount;
		}
		public String getIdCard() {
			return this.idCard;
		}
		public void setIdCard(String idCard) {
			this.idCard = idCard;
		}
		public Long getIdCardType() {
			return this.idCardType;
		}
		public void setIdCardType(Long idCardType) {
			this.idCardType = idCardType;
		}
		public String getInvoiceContent() {
			return this.invoiceContent;
		}
		public void setInvoiceContent(String invoiceContent) {
			this.invoiceContent = invoiceContent;
		}
		public Long getInvoiceId() {
			return this.invoiceId;
		}
		public void setInvoiceId(Long invoiceId) {
			this.invoiceId = invoiceId;
		}
		public String getInvoiceTitle() {
			return this.invoiceTitle;
		}
		public void setInvoiceTitle(String invoiceTitle) {
			this.invoiceTitle = invoiceTitle;
		}
		public Long getInvoiceType() {
			return this.invoiceType;
		}
		public void setInvoiceType(Long invoiceType) {
			this.invoiceType = invoiceType;
		}
		public String getLogisticsCode() {
			return this.logisticsCode;
		}
		public void setLogisticsCode(String logisticsCode) {
			this.logisticsCode = logisticsCode;
		}
		public Long getLogisticsId() {
			return this.logisticsId;
		}
		public void setLogisticsId(Long logisticsId) {
			this.logisticsId = logisticsId;
		}
		public List<Logisticslist> getLogisticsList() {
			return this.logisticsList;
		}
		public void setLogisticsList(List<Logisticslist> logisticsList) {
			this.logisticsList = logisticsList;
		}
		public String getLogisticsName() {
			return this.logisticsName;
		}
		public void setLogisticsName(String logisticsName) {
			this.logisticsName = logisticsName;
		}
		public String getLogisticsNo() {
			return this.logisticsNo;
		}
		public void setLogisticsNo(String logisticsNo) {
			this.logisticsNo = logisticsNo;
		}
		public Long getLogisticsPrintStatus() {
			return this.logisticsPrintStatus;
		}
		public void setLogisticsPrintStatus(Long logisticsPrintStatus) {
			this.logisticsPrintStatus = logisticsPrintStatus;
		}
		public Long getLogisticsType() {
			return this.logisticsType;
		}
		public void setLogisticsType(Long logisticsType) {
			this.logisticsType = logisticsType;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getNickName() {
			return this.nickName;
		}
		public void setNickName(String nickName) {
			this.nickName = nickName;
		}
		public Long getOperatorId() {
			return this.operatorId;
		}
		public void setOperatorId(Long operatorId) {
			this.operatorId = operatorId;
		}
		public String getOrderNo() {
			return this.orderNo;
		}
		public void setOrderNo(String orderNo) {
			this.orderNo = orderNo;
		}
		public Long getOrderType() {
			return this.orderType;
		}
		public void setOrderType(Long orderType) {
			this.orderType = orderType;
		}
		public String getOuterNo() {
			return this.outerNo;
		}
		public void setOuterNo(String outerNo) {
			this.outerNo = outerNo;
		}
		public String getPackageFee() {
			return this.packageFee;
		}
		public void setPackageFee(String packageFee) {
			this.packageFee = packageFee;
		}
		public String getPackagerName() {
			return this.packagerName;
		}
		public void setPackagerName(String packagerName) {
			this.packagerName = packagerName;
		}
		public String getPaid() {
			return this.paid;
		}
		public void setPaid(String paid) {
			this.paid = paid;
		}
		public String getPayTime() {
			return this.payTime;
		}
		public void setPayTime(String payTime) {
			this.payTime = payTime;
		}
		public String getPickerName() {
			return this.pickerName;
		}
		public void setPickerName(String pickerName) {
			this.pickerName = pickerName;
		}
		public String getPicklistNo() {
			return this.picklistNo;
		}
		public void setPicklistNo(String picklistNo) {
			this.picklistNo = picklistNo;
		}
		public Long getPicklistSeq() {
			return this.picklistSeq;
		}
		public void setPicklistSeq(Long picklistSeq) {
			this.picklistSeq = picklistSeq;
		}
		public Long getPlatformId() {
			return this.platformId;
		}
		public void setPlatformId(Long platformId) {
			this.platformId = platformId;
		}
		public String getPostAmount() {
			return this.postAmount;
		}
		public void setPostAmount(String postAmount) {
			this.postAmount = postAmount;
		}
		public String getPostFee() {
			return this.postFee;
		}
		public void setPostFee(String postFee) {
			this.postFee = postFee;
		}
		public String getPrintRemark() {
			return this.printRemark;
		}
		public void setPrintRemark(String printRemark) {
			this.printRemark = printRemark;
		}
		public String getPrinterName() {
			return this.printerName;
		}
		public void setPrinterName(String printerName) {
			this.printerName = printerName;
		}
		public String getReceivable() {
			return this.receivable;
		}
		public void setReceivable(String receivable) {
			this.receivable = receivable;
		}
		public String getReceiverAddress() {
			return this.receiverAddress;
		}
		public void setReceiverAddress(String receiverAddress) {
			this.receiverAddress = receiverAddress;
		}
		public String getReceiverArea() {
			return this.receiverArea;
		}
		public void setReceiverArea(String receiverArea) {
			this.receiverArea = receiverArea;
		}
		public Long getReceiverCity() {
			return this.receiverCity;
		}
		public void setReceiverCity(Long receiverCity) {
			this.receiverCity = receiverCity;
		}
		public Long getReceiverCountry() {
			return this.receiverCountry;
		}
		public void setReceiverCountry(Long receiverCountry) {
			this.receiverCountry = receiverCountry;
		}
		public Long getReceiverDistrict() {
			return this.receiverDistrict;
		}
		public void setReceiverDistrict(Long receiverDistrict) {
			this.receiverDistrict = receiverDistrict;
		}
		public String getReceiverDtb() {
			return this.receiverDtb;
		}
		public void setReceiverDtb(String receiverDtb) {
			this.receiverDtb = receiverDtb;
		}
		public String getReceiverMobile() {
			return this.receiverMobile;
		}
		public void setReceiverMobile(String receiverMobile) {
			this.receiverMobile = receiverMobile;
		}
		public String getReceiverName() {
			return this.receiverName;
		}
		public void setReceiverName(String receiverName) {
			this.receiverName = receiverName;
		}
		public Long getReceiverProvince() {
			return this.receiverProvince;
		}
		public void setReceiverProvince(Long receiverProvince) {
			this.receiverProvince = receiverProvince;
		}
		public String getReceiverTelno() {
			return this.receiverTelno;
		}
		public void setReceiverTelno(String receiverTelno) {
			this.receiverTelno = receiverTelno;
		}
		public String getReceiverZip() {
			return this.receiverZip;
		}
		public void setReceiverZip(String receiverZip) {
			this.receiverZip = receiverZip;
		}
		public Long getRefundStatus() {
			return this.refundStatus;
		}
		public void setRefundStatus(Long refundStatus) {
			this.refundStatus = refundStatus;
		}
		public String getRemark() {
			return this.remark;
		}
		public void setRemark(String remark) {
			this.remark = remark;
		}
		public String getSalesmanNo() {
			return this.salesmanNo;
		}
		public void setSalesmanNo(String salesmanNo) {
			this.salesmanNo = salesmanNo;
		}
		public Long getSendbillTemplateId() {
			return this.sendbillTemplateId;
		}
		public void setSendbillTemplateId(Long sendbillTemplateId) {
			this.sendbillTemplateId = sendbillTemplateId;
		}
		public Long getSeqNo() {
			return this.seqNo;
		}
		public void setSeqNo(Long seqNo) {
			this.seqNo = seqNo;
		}
		public Long getShopId() {
			return this.shopId;
		}
		public void setShopId(Long shopId) {
			this.shopId = shopId;
		}
		public String getShopName() {
			return this.shopName;
		}
		public void setShopName(String shopName) {
			this.shopName = shopName;
		}
		public String getShopNo() {
			return this.shopNo;
		}
		public void setShopNo(String shopNo) {
			this.shopNo = shopNo;
		}
		public Long getShopPlatformId() {
			return this.shopPlatformId;
		}
		public void setShopPlatformId(Long shopPlatformId) {
			this.shopPlatformId = shopPlatformId;
		}
		public String getShopRemark() {
			return this.shopRemark;
		}
		public void setShopRemark(String shopRemark) {
			this.shopRemark = shopRemark;
		}
		public Long getSrcOrderId() {
			return this.srcOrderId;
		}
		public void setSrcOrderId(Long srcOrderId) {
			this.srcOrderId = srcOrderId;
		}
		public String getSrcOrderNo() {
			return this.srcOrderNo;
		}
		public void setSrcOrderNo(String srcOrderNo) {
			this.srcOrderNo = srcOrderNo;
		}
		public String getSrcTradeNo() {
			return this.srcTradeNo;
		}
		public void setSrcTradeNo(String srcTradeNo) {
			this.srcTradeNo = srcTradeNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getStockCheckTime() {
			return this.stockCheckTime;
		}
		public void setStockCheckTime(String stockCheckTime) {
			this.stockCheckTime = stockCheckTime;
		}
		public Long getStockoutId() {
			return this.stockoutId;
		}
		public void setStockoutId(Long stockoutId) {
			this.stockoutId = stockoutId;
		}
		public Long getSubPlatformId() {
			return this.subPlatformId;
		}
		public void setSubPlatformId(Long subPlatformId) {
			this.subPlatformId = subPlatformId;
		}
		public String getTax() {
			return this.tax;
		}
		public void setTax(String tax) {
			this.tax = tax;
		}
		public String getTaxRate() {
			return this.taxRate;
		}
		public void setTaxRate(String taxRate) {
			this.taxRate = taxRate;
		}
		public Long getTradeFrom() {
			return this.tradeFrom;
		}
		public void setTradeFrom(Long tradeFrom) {
			this.tradeFrom = tradeFrom;
		}
		public Long getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(Long tradeId) {
			this.tradeId = tradeId;
		}
		public String getTradeLabel() {
			return this.tradeLabel;
		}
		public void setTradeLabel(String tradeLabel) {
			this.tradeLabel = tradeLabel;
		}
		public String getTradeNo() {
			return this.tradeNo;
		}
		public void setTradeNo(String tradeNo) {
			this.tradeNo = tradeNo;
		}
		public Long getTradeStatus() {
			return this.tradeStatus;
		}
		public void setTradeStatus(Long tradeStatus) {
			this.tradeStatus = tradeStatus;
		}
		public String getTradeTime() {
			return this.tradeTime;
		}
		public void setTradeTime(String tradeTime) {
			this.tradeTime = tradeTime;
		}
		public Long getTradeType() {
			return this.tradeType;
		}
		public void setTradeType(Long tradeType) {
			this.tradeType = tradeType;
		}
		public Long getWarehouseId() {
			return this.warehouseId;
		}
		public void setWarehouseId(Long warehouseId) {
			this.warehouseId = warehouseId;
		}
		public String getWarehouseMappingCode() {
			return this.warehouseMappingCode;
		}
		public void setWarehouseMappingCode(String warehouseMappingCode) {
			this.warehouseMappingCode = warehouseMappingCode;
		}
		public String getWarehouseName() {
			return this.warehouseName;
		}
		public void setWarehouseName(String warehouseName) {
			this.warehouseName = warehouseName;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}
		public Long getWarehouseType() {
			return this.warehouseType;
		}
		public void setWarehouseType(Long warehouseType) {
			this.warehouseType = warehouseType;
		}
		public String getWeight() {
			return this.weight;
		}
		public void setWeight(String weight) {
			this.weight = weight;
		}

}

	/**
 * 出库单信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据数据
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 查询条件总单据数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
