package com.qimencloud.api.scene3ldsmu02o9.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API(QimenCloud): wdt.wms.stockshelve.querywithdetail response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class WdtWmsStockshelveQuerywithdetailResponse extends TaobaoResponse {

	private static final long serialVersionUID = 2463245711239819252L;

	/** 
	 * 单据信息
	 */
	@ApiField("data")
	private Data data;

	/** 
	 * 错误信息（无错误信息不返回）
	 */
	@ApiField("message")
	private String message;

	/** 
	 * 状态码（返回0为正常）
	 */
	@ApiField("status")
	private Long status;


	public void setData(Data data) {
		this.data = data;
	}
	public Data getData( ) {
		return this.data;
	}

	public void setMessage(String message) {
		this.message = message;
	}
	public String getMessage( ) {
		return this.message;
	}

	public void setStatus(Long status) {
		this.status = status;
	}
	public Long getStatus( ) {
		return this.status;
	}
	
	/**
 * 补货单明细
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class DetailList {

	/**
		 * 条码
		 */
		@ApiField("barcode")
		private String barcode;
		/**
		 * 补货车框位
		 */
		@ApiField("cart_seat")
		private String cartSeat;
		/**
		 * 是否残次品
		 */
		@ApiField("defect")
		private Boolean defect;
		/**
		 * 下架数量
		 */
		@ApiField("down_num")
		private String downNum;
		/**
		 * 有效期
		 */
		@ApiField("expire_date")
		private String expireDate;
		/**
		 * 源货位
		 */
		@ApiField("from_position_no")
		private String fromPositionNo;
		/**
		 * 货品名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 货品编号
		 */
		@ApiField("goods_no")
		private String goodsNo;
		/**
		 * 补货单ID
		 */
		@ApiField("order_id")
		private Long orderId;
		/**
		 * 简称
		 */
		@ApiField("short_name")
		private String shortName;
		/**
		 * 规格码
		 */
		@ApiField("spec_code")
		private String specCode;
		/**
		 * 单品ID
		 */
		@ApiField("spec_id")
		private Long specId;
		/**
		 * 单品名称
		 */
		@ApiField("spec_name")
		private String specName;
		/**
		 * 商家编码
		 */
		@ApiField("spec_no")
		private String specNo;
		/**
		 * 目标货位
		 */
		@ApiField("to_position_no")
		private String toPositionNo;
		/**
		 * 上架数量
		 */
		@ApiField("up_num")
		private String upNum;
	

	public String getBarcode() {
			return this.barcode;
		}
		public void setBarcode(String barcode) {
			this.barcode = barcode;
		}
		public String getCartSeat() {
			return this.cartSeat;
		}
		public void setCartSeat(String cartSeat) {
			this.cartSeat = cartSeat;
		}
		public Boolean getDefect() {
			return this.defect;
		}
		public void setDefect(Boolean defect) {
			this.defect = defect;
		}
		public String getDownNum() {
			return this.downNum;
		}
		public void setDownNum(String downNum) {
			this.downNum = downNum;
		}
		public String getExpireDate() {
			return this.expireDate;
		}
		public void setExpireDate(String expireDate) {
			this.expireDate = expireDate;
		}
		public String getFromPositionNo() {
			return this.fromPositionNo;
		}
		public void setFromPositionNo(String fromPositionNo) {
			this.fromPositionNo = fromPositionNo;
		}
		public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsNo() {
			return this.goodsNo;
		}
		public void setGoodsNo(String goodsNo) {
			this.goodsNo = goodsNo;
		}
		public Long getOrderId() {
			return this.orderId;
		}
		public void setOrderId(Long orderId) {
			this.orderId = orderId;
		}
		public String getShortName() {
			return this.shortName;
		}
		public void setShortName(String shortName) {
			this.shortName = shortName;
		}
		public String getSpecCode() {
			return this.specCode;
		}
		public void setSpecCode(String specCode) {
			this.specCode = specCode;
		}
		public Long getSpecId() {
			return this.specId;
		}
		public void setSpecId(Long specId) {
			this.specId = specId;
		}
		public String getSpecName() {
			return this.specName;
		}
		public void setSpecName(String specName) {
			this.specName = specName;
		}
		public String getSpecNo() {
			return this.specNo;
		}
		public void setSpecNo(String specNo) {
			this.specNo = specNo;
		}
		public String getToPositionNo() {
			return this.toPositionNo;
		}
		public void setToPositionNo(String toPositionNo) {
			this.toPositionNo = toPositionNo;
		}
		public String getUpNum() {
			return this.upNum;
		}
		public void setUpNum(String upNum) {
			this.upNum = upNum;
		}

}

	/**
 * 单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Order {

	/**
		 * 创建时间
		 */
		@ApiField("created")
		private String created;
		/**
		 * 补货单明细
		 */
		@ApiListField("detail_list")
		@ApiField("detailList")
		private List<DetailList> detailList;
		/**
		 * 目标货区
		 */
		@ApiField("from_zone_no")
		private String fromZoneNo;
		/**
		 * 修改时间
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 操作员
		 */
		@ApiField("operator_name")
		private String operatorName;
		/**
		 * 补货单号
		 */
		@ApiField("order_no")
		private String orderNo;
		/**
		 * 状态（0已取消 10待审核 20已审核）
		 */
		@ApiField("status")
		private Long status;
		/**
		 * 源货区
		 */
		@ApiField("to_zone_no")
		private String toZoneNo;
		/**
		 * 类型
		 */
		@ApiField("type")
		private Long type;
		/**
		 * 仓库编号
		 */
		@ApiField("warehouse_no")
		private String warehouseNo;
	

	public String getCreated() {
			return this.created;
		}
		public void setCreated(String created) {
			this.created = created;
		}
		public List<DetailList> getDetailList() {
			return this.detailList;
		}
		public void setDetailList(List<DetailList> detailList) {
			this.detailList = detailList;
		}
		public String getFromZoneNo() {
			return this.fromZoneNo;
		}
		public void setFromZoneNo(String fromZoneNo) {
			this.fromZoneNo = fromZoneNo;
		}
		public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public String getOperatorName() {
			return this.operatorName;
		}
		public void setOperatorName(String operatorName) {
			this.operatorName = operatorName;
		}
		public String getOrderNo() {
			return this.orderNo;
		}
		public void setOrderNo(String orderNo) {
			this.orderNo = orderNo;
		}
		public Long getStatus() {
			return this.status;
		}
		public void setStatus(Long status) {
			this.status = status;
		}
		public String getToZoneNo() {
			return this.toZoneNo;
		}
		public void setToZoneNo(String toZoneNo) {
			this.toZoneNo = toZoneNo;
		}
		public Long getType() {
			return this.type;
		}
		public void setType(Long type) {
			this.type = type;
		}
		public String getWarehouseNo() {
			return this.warehouseNo;
		}
		public void setWarehouseNo(String warehouseNo) {
			this.warehouseNo = warehouseNo;
		}

}

	/**
 * 单据信息
 *
 * @author top auto create
 * @since 1.0, null
 */
 
public static class Data {

	/**
		 * 单据信息
		 */
		@ApiListField("order")
		@ApiField("order")
		private List<Order> order;
		/**
		 * 总条数
		 */
		@ApiField("total_count")
		private Long totalCount;
	

	public List<Order> getOrder() {
			return this.order;
		}
		public void setOrder(List<Order> order) {
			this.order = order;
		}
		public Long getTotalCount() {
			return this.totalCount;
		}
		public void setTotalCount(Long totalCount) {
			this.totalCount = totalCount;
		}

}



}
