package com.taobao.api.domain;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;


/**
 * 物流服务承诺
 *
 * @author top auto create
 * @since 1.0, null
 */
public class LogisticsAgreement extends TaobaoObject {

	private static final long serialVersionUID = 2622478396515765972L;

	/**
	 * 物流信息，多个值时用英文逗号隔开
	 */
	@ApiField("asdp_ads")
	private String asdpAds;

	/**
	 * 物流服务业务身份
	 */
	@ApiField("asdp_biz_type")
	private String asdpBizType;

	/**
	 * 服务承诺异常文案
	 */
	@ApiField("logistics_service_msg")
	private String logisticsServiceMsg;

	/**
	 * 1：不支持子单部分发货
	 */
	@ApiField("no_detail_part_consign")
	private String noDetailPartConsign;

	/**
	 * 承诺最晚送达时间
	 */
	@ApiField("promise_sign_time")
	private String promiseSignTime;

	/**
	 * ERP应推单时间(主单)
	 */
	@ApiField("push_time")
	private String pushTime;

	/**
	 * 计划送达时间
	 */
	@ApiField("sign_time")
	private String signTime;

	/**
	 * 1：代表该订单是预售下沉订单类型为前置表达
	 */
	@ApiField("sink_type")
	private String sinkType;


	public String getAsdpAds() {
		return this.asdpAds;
	}
	public void setAsdpAds(String asdpAds) {
		this.asdpAds = asdpAds;
	}

	public String getAsdpBizType() {
		return this.asdpBizType;
	}
	public void setAsdpBizType(String asdpBizType) {
		this.asdpBizType = asdpBizType;
	}

	public String getLogisticsServiceMsg() {
		return this.logisticsServiceMsg;
	}
	public void setLogisticsServiceMsg(String logisticsServiceMsg) {
		this.logisticsServiceMsg = logisticsServiceMsg;
	}

	public String getNoDetailPartConsign() {
		return this.noDetailPartConsign;
	}
	public void setNoDetailPartConsign(String noDetailPartConsign) {
		this.noDetailPartConsign = noDetailPartConsign;
	}

	public String getPromiseSignTime() {
		return this.promiseSignTime;
	}
	public void setPromiseSignTime(String promiseSignTime) {
		this.promiseSignTime = promiseSignTime;
	}

	public String getPushTime() {
		return this.pushTime;
	}
	public void setPushTime(String pushTime) {
		this.pushTime = pushTime;
	}

	public String getSignTime() {
		return this.signTime;
	}
	public void setSignTime(String signTime) {
		this.signTime = signTime;
	}

	public String getSinkType() {
		return this.sinkType;
	}
	public void setSinkType(String sinkType) {
		this.sinkType = sinkType;
	}

}
