package com.taobao.api.domain;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;


/**
 * 支付通道计算结果
 *
 * @author top auto create
 * @since 1.0, null
 */
public class PayChannelResult extends TaobaoObject {

	private static final long serialVersionUID = 8554545784579966178L;

	/**
	 * 支付宝系支付渠道
	 */
	@ApiListField("ap_channel_list")
	@ApiField("acquire_order_pay_channel")
	private List<AcquireOrderPayChannel> apChannelList;

	/**
	 * 支付宝总的支付金额  单位分
	 */
	@ApiField("ap_channel_pay_fee")
	private Long apChannelPayFee;

	/**
	 * 所有优惠券的购买金额. 单位分
	 */
	@ApiField("tb_channel_buy_fee")
	private Long tbChannelBuyFee;

	/**
	 * 淘宝系支付渠道
	 */
	@ApiListField("tb_channel_list")
	@ApiField("acquire_order_pay_channel")
	private List<AcquireOrderPayChannel> tbChannelList;

	/**
	 * 实际优惠金额(输入订单金额-实付金额)  单位分
	 */
	@ApiField("tb_channel_promotion_fee")
	private Long tbChannelPromotionFee;


	public List<AcquireOrderPayChannel> getApChannelList() {
		return this.apChannelList;
	}
	public void setApChannelList(List<AcquireOrderPayChannel> apChannelList) {
		this.apChannelList = apChannelList;
	}

	public Long getApChannelPayFee() {
		return this.apChannelPayFee;
	}
	public void setApChannelPayFee(Long apChannelPayFee) {
		this.apChannelPayFee = apChannelPayFee;
	}

	public Long getTbChannelBuyFee() {
		return this.tbChannelBuyFee;
	}
	public void setTbChannelBuyFee(Long tbChannelBuyFee) {
		this.tbChannelBuyFee = tbChannelBuyFee;
	}

	public List<AcquireOrderPayChannel> getTbChannelList() {
		return this.tbChannelList;
	}
	public void setTbChannelList(List<AcquireOrderPayChannel> tbChannelList) {
		this.tbChannelList = tbChannelList;
	}

	public Long getTbChannelPromotionFee() {
		return this.tbChannelPromotionFee;
	}
	public void setTbChannelPromotionFee(Long tbChannelPromotionFee) {
		this.tbChannelPromotionFee = tbChannelPromotionFee;
	}

}
