package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.AlibabaItemEditSchemaGetResponse;

/**
 * TOP API: alibaba.item.edit.schema.get request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.19
 */
public class AlibabaItemEditSchemaGetRequest extends BaseTaobaoRequest<AlibabaItemEditSchemaGetResponse> {
	
	

	/** 
	* 业务扩展参数，需与平台约定好
	 */
	private String bizType;

	/** 
	* 制定返回schema中field字段列表，可用于裁剪返回的schema信息。不填则为全部field
	 */
	private String fields;

	/** 
	* 商品ID
	 */
	private Long itemId;

	public void setBizType(String bizType) {
		this.bizType = bizType;
	}

	public String getBizType() {
		return this.bizType;
	}

	public void setFields(String fields) {
		this.fields = fields;
	}

	public String getFields() {
		return this.fields;
	}

	public void setItemId(Long itemId) {
		this.itemId = itemId;
	}

	public Long getItemId() {
		return this.itemId;
	}

	public String getApiMethodName() {
		return "alibaba.item.edit.schema.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("biz_type", this.bizType);
		txtParams.put("fields", this.fields);
		txtParams.put("item_id", this.itemId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<AlibabaItemEditSchemaGetResponse> getResponseClass() {
		return AlibabaItemEditSchemaGetResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkMaxListSize(fields, 999, "fields");
		RequestCheckUtils.checkNotEmpty(itemId, "itemId");
	}
	

}