package com.taobao.api.request;

import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.FenxiaoRefundGetResponse;

/**
 * TOP API: taobao.fenxiao.refund.get request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.01
 */
public class FenxiaoRefundGetRequest extends BaseTaobaoRequest<FenxiaoRefundGetResponse> {
	
	

	/** 
	* 是否查询下游消费者订单对应退款信息
	 */
	private Boolean querySellerRefund;

	/** 
	* 退款单id（分销子订单号和退款单id，两者至少必填一个，都填的情况下，以退款单id为准）
	 */
	private Long refundId;

	/** 
	* 要查询的退款对应的分销子订单号
	 */
	private Long subOrderId;

	public void setQuerySellerRefund(Boolean querySellerRefund) {
		this.querySellerRefund = querySellerRefund;
	}

	public Boolean getQuerySellerRefund() {
		return this.querySellerRefund;
	}

	public void setRefundId(Long refundId) {
		this.refundId = refundId;
	}

	public Long getRefundId() {
		return this.refundId;
	}

	public void setSubOrderId(Long subOrderId) {
		this.subOrderId = subOrderId;
	}

	public Long getSubOrderId() {
		return this.subOrderId;
	}

	public String getApiMethodName() {
		return "taobao.fenxiao.refund.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("query_seller_refund", this.querySellerRefund);
		txtParams.put("refund_id", this.refundId);
		txtParams.put("sub_order_id", this.subOrderId);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<FenxiaoRefundGetResponse> getResponseClass() {
		return FenxiaoRefundGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}