package com.taobao.api.request;

import com.taobao.api.internal.util.RequestCheckUtils;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;

import com.taobao.api.response.LogisticsInstantTraceSearchResponse;

/**
 * TOP API: taobao.logistics.instant.trace.search request
 * 
 * @author top auto create
 * @since 1.0, 2022.12.19
 */
public class LogisticsInstantTraceSearchRequest extends BaseTaobaoRequest<LogisticsInstantTraceSearchResponse> {
	
	

	/** 
	* 是否拆单
	 */
	private Long isSplit;

	/** 
	* 运单号
	 */
	private String mailNo;

	/** 
	* 子订单列表
	 */
	private String subTid;

	/** 
	* 交易单号
	 */
	private Long tid;

	public void setIsSplit(Long isSplit) {
		this.isSplit = isSplit;
	}

	public Long getIsSplit() {
		return this.isSplit;
	}

	public void setMailNo(String mailNo) {
		this.mailNo = mailNo;
	}

	public String getMailNo() {
		return this.mailNo;
	}

	public void setSubTid(String subTid) {
		this.subTid = subTid;
	}

	public String getSubTid() {
		return this.subTid;
	}

	public void setTid(Long tid) {
		this.tid = tid;
	}

	public Long getTid() {
		return this.tid;
	}

	public String getApiMethodName() {
		return "taobao.logistics.instant.trace.search";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("is_split", this.isSplit);
		txtParams.put("mail_no", this.mailNo);
		txtParams.put("sub_tid", this.subTid);
		txtParams.put("tid", this.tid);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<LogisticsInstantTraceSearchResponse> getResponseClass() {
		return LogisticsInstantTraceSearchResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkNotEmpty(tid, "tid");
	}
	

}