package com.taobao.api.request;

import com.taobao.api.domain.QrCodeInput;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.OtoOrderBuildQrcodeResponse;

/**
 * TOP API: taobao.oto.order.build.qrcode request
 * 
 * @author top auto create
 * @since 1.0, 2018.07.25
 */
public class OtoOrderBuildQrcodeRequest extends BaseTaobaoRequest<OtoOrderBuildQrcodeResponse> {
	
	

	/** 
	* 创建二维码输入参数
	 */
	private String qrCodeInput;

	public void setQrCodeInput(String qrCodeInput) {
		this.qrCodeInput = qrCodeInput;
	}

	public void setQrCodeInput(QrCodeInput qrCodeInput) {
		this.qrCodeInput = new JSONWriter(false,true).write(qrCodeInput);
	}

	public String getQrCodeInput() {
		return this.qrCodeInput;
	}

	public String getApiMethodName() {
		return "taobao.oto.order.build.qrcode";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("qr_code_input", this.qrCodeInput);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<OtoOrderBuildQrcodeResponse> getResponseClass() {
		return OtoOrderBuildQrcodeResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	

}