package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TmallChannelProductsGetResponse;

/**
 * TOP API: tmall.channel.products.get request
 * 
 * @author top auto create
 * @since 1.0, 2024.03.01
 */
public class TmallChannelProductsGetRequest extends BaseTaobaoRequest<TmallChannelProductsGetResponse> {
	
	

	/** 
	* top_query_product_d_o
	 */
	private String topQueryProductDO;

	public void setTopQueryProductDO(String topQueryProductDO) {
		this.topQueryProductDO = topQueryProductDO;
	}

	public void setTopQueryProductDO(TopQueryProductDo topQueryProductDO) {
		this.topQueryProductDO = new JSONWriter(false,true).write(topQueryProductDO);
	}

	public String getTopQueryProductDO() {
		return this.topQueryProductDO;
	}

	public String getApiMethodName() {
		return "tmall.channel.products.get";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("top_query_product_d_o", this.topQueryProductDO);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TmallChannelProductsGetResponse> getResponseClass() {
		return TmallChannelProductsGetResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * top_query_product_d_o
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class TopQueryProductDo extends TaobaoObject {

	private static final long serialVersionUID = 4441146397416916746L;

	/**
		 * 渠道[21 零售plus]
		 */
		@ApiField("channel")
		private Long channel;
		/**
		 * 要查询的产品id 列表
		 */
		@ApiListField("ids")
		@ApiField("number")
		private List<Long> ids;
		/**
		 * 关联的前端宝贝id列表
		 */
		@ApiListField("item_ids")
		@ApiField("number")
		private List<Long> itemIds;
		/**
		 * 当前要查看的页数
		 */
		@ApiField("page_num")
		private Long pageNum;
		/**
		 * 分页大小
		 */
		@ApiField("page_size")
		private Long pageSize;
		/**
		 * 产品线id
		 */
		@ApiField("product_line_id")
		private Long productLineId;
		/**
		 * 产品商家编码
		 */
		@ApiField("product_outer_id")
		private String productOuterId;
		/**
		 * sku商家编码
		 */
		@ApiField("sku_outer_id")
		private String skuOuterId;
	

	public Long getChannel() {
			return this.channel;
		}
		public void setChannel(Long channel) {
			this.channel = channel;
		}
		public List<Long> getIds() {
			return this.ids;
		}
		public void setIds(List<Long> ids) {
			this.ids = ids;
		}
		public List<Long> getItemIds() {
			return this.itemIds;
		}
		public void setItemIds(List<Long> itemIds) {
			this.itemIds = itemIds;
		}
		public Long getPageNum() {
			return this.pageNum;
		}
		public void setPageNum(Long pageNum) {
			this.pageNum = pageNum;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}
		public Long getProductLineId() {
			return this.productLineId;
		}
		public void setProductLineId(Long productLineId) {
			this.productLineId = productLineId;
		}
		public String getProductOuterId() {
			return this.productOuterId;
		}
		public void setProductOuterId(String productOuterId) {
			this.productOuterId = productOuterId;
		}
		public String getSkuOuterId() {
			return this.skuOuterId;
		}
		public void setSkuOuterId(String skuOuterId) {
			this.skuOuterId = skuOuterId;
		}

}


}