package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.util.RequestCheckUtils;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TopOaidClientDecryptResponse;

/**
 * TOP API: taobao.top.oaid.client.decrypt request
 * 
 * @author top auto create
 * @since 1.0, 2022.10.13
 */
public class TopOaidClientDecryptRequest extends BaseTaobaoRequest<TopOaidClientDecryptResponse> {
	
	

	/** 
	* 解密请求列表，长度不要超过1（只能单笔解密，不支持批量解密）。
	 */
	private String queryList;

	/** 
	* 安全令牌
	 */
	private String secOnceToken;

	public void setQueryList(String queryList) {
		this.queryList = queryList;
	}

	public void setQueryList(List<ReceiverQuery> queryList) {
		this.queryList = new JSONWriter(false,true).write(queryList);
	}

	public String getQueryList() {
		return this.queryList;
	}

	public void setSecOnceToken(String secOnceToken) {
		this.secOnceToken = secOnceToken;
	}

	public String getSecOnceToken() {
		return this.secOnceToken;
	}

	public String getApiMethodName() {
		return "taobao.top.oaid.client.decrypt";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("query_list", this.queryList);
		txtParams.put("sec_once_token", this.secOnceToken);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TopOaidClientDecryptResponse> getResponseClass() {
		return TopOaidClientDecryptResponse.class;
	}

	public void check() throws ApiRuleException {
		RequestCheckUtils.checkObjectMaxListSize(queryList, 999, "queryList");
		RequestCheckUtils.checkNotEmpty(secOnceToken, "secOnceToken");
	}
	
	/**
 * 解密请求列表，长度不要超过1（只能单笔解密，不支持批量解密）。
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ReceiverQuery extends TaobaoObject {

	private static final long serialVersionUID = 1844977145193496845L;

	/**
		 * 收件人ID (Open Addressee ID)，长度在128个字符之内。
		 */
		@ApiField("oaid")
		private String oaid;
		/**
		 * 解密场景编号。不同场景，解密策略不同。请根据产品功能选择相应的场景编号。可选的场景：1001(顺丰电子面单发货)、1002(4通一达电子面单发货)、1003(EMS电子面单发货)、1004(其他电子面单发货)、1005(线下门店发货)、1006(手工单发货)、1007(代发货)、2001(客户售后服务)、2002(客户关怀)，<a href="https:open.taobao.comdoc.htm?docId=120186&docType=1" target="_blank">详情点击<a>
		 */
		@ApiField("scene")
		private String scene;
		/**
		 * 隐私号绑定天数
		 */
		@ApiField("secret_no_days")
		private Long secretNoDays;
		/**
		 * 交易订单ID
		 */
		@ApiField("tid")
		private String tid;
	

	public String getOaid() {
			return this.oaid;
		}
		public void setOaid(String oaid) {
			this.oaid = oaid;
		}
		public String getScene() {
			return this.scene;
		}
		public void setScene(String scene) {
			this.scene = scene;
		}
		public Long getSecretNoDays() {
			return this.secretNoDays;
		}
		public void setSecretNoDays(Long secretNoDays) {
			this.secretNoDays = secretNoDays;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}

}


}