package com.taobao.api.request;

import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Date;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.TopSecretBillDetailResponse;

/**
 * TOP API: taobao.top.secret.bill.detail request
 * 
 * @author top auto create
 * @since 1.0, 2022.08.23
 */
public class TopSecretBillDetailRequest extends BaseTaobaoRequest<TopSecretBillDetailResponse> {
	
	

	/** 
	* 卖家账单查询
	 */
	private String sellerBillQueryRequest;

	public void setSellerBillQueryRequest(String sellerBillQueryRequest) {
		this.sellerBillQueryRequest = sellerBillQueryRequest;
	}

	public void setSellerBillQueryRequest(SellerBillQueryRequest sellerBillQueryRequest) {
		this.sellerBillQueryRequest = new JSONWriter(false,true).write(sellerBillQueryRequest);
	}

	public String getSellerBillQueryRequest() {
		return this.sellerBillQueryRequest;
	}

	public String getApiMethodName() {
		return "taobao.top.secret.bill.detail";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("seller_bill_query_request", this.sellerBillQueryRequest);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<TopSecretBillDetailResponse> getResponseClass() {
		return TopSecretBillDetailResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 卖家账单查询
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class SellerBillQueryRequest extends TaobaoObject {

	private static final long serialVersionUID = 5146158847689444469L;

	/**
		 * 账单时间
		 */
		@ApiField("biz_date")
		private Date bizDate;
		/**
		 * 页号，从1开始
		 */
		@ApiField("page_no")
		private Long pageNo;
		/**
		 * 页大小，不得超过1000
		 */
		@ApiField("page_size")
		private Long pageSize;
	

	public Date getBizDate() {
			return this.bizDate;
		}
		public void setBizDate(Date bizDate) {
			this.bizDate = bizDate;
		}
		public Long getPageNo() {
			return this.pageNo;
		}
		public void setPageNo(Long pageNo) {
			this.pageNo = pageNo;
		}
		public Long getPageSize() {
			return this.pageSize;
		}
		public void setPageSize(Long pageSize) {
			this.pageSize = pageSize;
		}

}


}