package com.taobao.api.request;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.TaobaoObject;
import java.util.Map;

import com.taobao.api.ApiRuleException;
import com.taobao.api.BaseTaobaoRequest;
import com.taobao.api.internal.util.TaobaoHashMap;
import com.taobao.api.internal.util.json.JSONWriter;
import com.taobao.api.response.UserOpenuidGetbyorderResponse;

/**
 * TOP API: taobao.user.openuid.getbyorder request
 * 
 * @author top auto create
 * @since 1.0, 2022.09.06
 */
public class UserOpenuidGetbyorderRequest extends BaseTaobaoRequest<UserOpenuidGetbyorderResponse> {
	
	

	/** 
	* 买家订单列表
	 */
	private String tidInfos;

	public void setTidInfos(String tidInfos) {
		this.tidInfos = tidInfos;
	}

	public void setTidInfos(List<BuyerOrder> tidInfos) {
		this.tidInfos = new JSONWriter(false,true).write(tidInfos);
	}

	public String getTidInfos() {
		return this.tidInfos;
	}

	public String getApiMethodName() {
		return "taobao.user.openuid.getbyorder";
	}

	public Map<String, String> getTextParams() {		
		TaobaoHashMap txtParams = new TaobaoHashMap();
		txtParams.put("tid_infos", this.tidInfos);
		if(this.udfParams != null) {
			txtParams.putAll(this.udfParams);
		}
		return txtParams;
	}

	public Class<UserOpenuidGetbyorderResponse> getResponseClass() {
		return UserOpenuidGetbyorderResponse.class;
	}

	public void check() throws ApiRuleException {
	}
	
	/**
 * 买家订单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class BuyerOrder extends TaobaoObject {

	private static final long serialVersionUID = 3842237242997974741L;

	/**
		 * 买家nick
		 */
		@ApiField("buyer_nick")
		private String buyerNick;
		/**
		 * 订单id
		 */
		@ApiField("tid")
		private Long tid;
	

	public String getBuyerNick() {
			return this.buyerNick;
		}
		public void setBuyerNick(String buyerNick) {
			this.buyerNick = buyerNick;
		}
		public Long getTid() {
			return this.tid;
		}
		public void setTid(Long tid) {
			this.tid = tid;
		}

}


}