package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: alibaba.ascp.logistics.seller.orders.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class AlibabaAscpLogisticsSellerOrdersGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 6845693457196674387L;

	/** 
	 * 返回值
	 */
	@ApiField("result")
	private ResultDTO result;


	public void setResult(ResultDTO result) {
		this.result = result;
	}
	public ResultDTO getResult( ) {
		return this.result;
	}
	
	/**
 * 交易单所包含的商品列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WriteOffGoodsDTO extends TaobaoObject {

	private static final long serialVersionUID = 7678522833175298746L;

	/**
		 * 名称
		 */
		@ApiField("goods_name")
		private String goodsName;
		/**
		 * 商品图片地址
		 */
		@ApiField("goods_pic_id")
		private String goodsPicId;
		/**
		 * 数量
		 */
		@ApiField("goods_quantity")
		private Long goodsQuantity;
		/**
		 * 商品Id
		 */
		@ApiField("item_id")
		private String itemId;
		/**
		 * 价格
		 */
		@ApiField("price")
		private String price;
		/**
		 * 商品sku id
		 */
		@ApiField("sku_id")
		private String skuId;
	

	public String getGoodsName() {
			return this.goodsName;
		}
		public void setGoodsName(String goodsName) {
			this.goodsName = goodsName;
		}
		public String getGoodsPicId() {
			return this.goodsPicId;
		}
		public void setGoodsPicId(String goodsPicId) {
			this.goodsPicId = goodsPicId;
		}
		public Long getGoodsQuantity() {
			return this.goodsQuantity;
		}
		public void setGoodsQuantity(Long goodsQuantity) {
			this.goodsQuantity = goodsQuantity;
		}
		public String getItemId() {
			return this.itemId;
		}
		public void setItemId(String itemId) {
			this.itemId = itemId;
		}
		public String getPrice() {
			return this.price;
		}
		public void setPrice(String price) {
			this.price = price;
		}
		public String getSkuId() {
			return this.skuId;
		}
		public void setSkuId(String skuId) {
			this.skuId = skuId;
		}

}

	/**
 * 返回核销订单列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class WriteOffOrderDTO extends TaobaoObject {

	private static final long serialVersionUID = 5655871883842818348L;

	/**
		 * 交易单所包含的商品列表
		 */
		@ApiListField("goods_list")
		@ApiField("write_off_goods_d_t_o")
		private List<WriteOffGoodsDTO> goodsList;
		/**
		 * 核销订单Id
		 */
		@ApiField("lp_order_id")
		private String lpOrderId;
		/**
		 * 淘宝交易Id
		 */
		@ApiField("trade_id")
		private String tradeId;
	

	public List<WriteOffGoodsDTO> getGoodsList() {
			return this.goodsList;
		}
		public void setGoodsList(List<WriteOffGoodsDTO> goodsList) {
			this.goodsList = goodsList;
		}
		public String getLpOrderId() {
			return this.lpOrderId;
		}
		public void setLpOrderId(String lpOrderId) {
			this.lpOrderId = lpOrderId;
		}
		public String getTradeId() {
			return this.tradeId;
		}
		public void setTradeId(String tradeId) {
			this.tradeId = tradeId;
		}

}

	/**
 * 返回值
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultDTO extends TaobaoObject {

	private static final long serialVersionUID = 6268783134898246137L;

	/**
		 * 是否成功
		 */
		@ApiField("success")
		private Boolean success;
		/**
		 * 返回核销订单列表
		 */
		@ApiListField("writeoff_order_list")
		@ApiField("write_off_order_d_t_o")
		private List<WriteOffOrderDTO> writeoffOrderList;
	

	public Boolean getSuccess() {
			return this.success;
		}
		public void setSuccess(Boolean success) {
			this.success = success;
		}
		public List<WriteOffOrderDTO> getWriteoffOrderList() {
			return this.writeoffOrderList;
		}
		public void setWriteoffOrderList(List<WriteOffOrderDTO> writeoffOrderList) {
			this.writeoffOrderList = writeoffOrderList;
		}

}



}
