package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.refund.status.get response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class RefundStatusGetResponse extends TaobaoResponse {

	private static final long serialVersionUID = 1518515182426797173L;

	/** 
	 * 出参对象
	 */
	@ApiField("result_package")
	private ResultSet resultPackage;


	public void setResultPackage(ResultSet resultPackage) {
		this.resultPackage = resultPackage;
	}
	public ResultSet getResultPackage( ) {
		return this.resultPackage;
	}
	
	/**
 * 数组对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class QueryRefundStatusResponse extends TaobaoObject {

	private static final long serialVersionUID = 2868479965582535326L;

	/**
		 * 更新时间。格式:yyyy-MM-dd HH:mm:ss
		 */
		@ApiField("modified")
		private String modified;
		/**
		 * 子订单号
		 */
		@ApiField("oid")
		private Long oid;
		/**
		 * 退款单id
		 */
		@ApiField("refund_id")
		private Long refundId;
		/**
		 * 退款状态。可选值WAIT_SELLER_AGREE(买家已经申请退款，等待卖家同意) WAIT_BUYER_RETURN_GOODS(卖家已经同意退款，等待买家退货) WAIT_SELLER_CONFIRM_GOODS(买家已经退货，等待卖家确认收货) SELLER_REFUSE_BUYER(卖家拒绝退款) CLOSED(退款关闭) SUCCESS(退款成功)
		 */
		@ApiField("status")
		private String status;
		/**
		 * 淘宝交易单号
		 */
		@ApiField("tid")
		private Long tid;
	

	public String getModified() {
			return this.modified;
		}
		public void setModified(String modified) {
			this.modified = modified;
		}
		public Long getOid() {
			return this.oid;
		}
		public void setOid(Long oid) {
			this.oid = oid;
		}
		public Long getRefundId() {
			return this.refundId;
		}
		public void setRefundId(Long refundId) {
			this.refundId = refundId;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}
		public Long getTid() {
			return this.tid;
		}
		public void setTid(Long tid) {
			this.tid = tid;
		}

}

	/**
 * 出参对象
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class ResultSet extends TaobaoObject {

	private static final long serialVersionUID = 4884932529649367569L;

	/**
		 * 错误码，没有表示无异常
		 */
		@ApiField("error_code")
		private String errorCode;
		/**
		 * 错误信息
		 */
		@ApiField("error_msg")
		private String errorMsg;
		/**
		 * 数组对象
		 */
		@ApiListField("result_list")
		@ApiField("query_refund_status_response")
		private List<QueryRefundStatusResponse> resultList;
	

	public String getErrorCode() {
			return this.errorCode;
		}
		public void setErrorCode(String errorCode) {
			this.errorCode = errorCode;
		}
		public String getErrorMsg() {
			return this.errorMsg;
		}
		public void setErrorMsg(String errorMsg) {
			this.errorMsg = errorMsg;
		}
		public List<QueryRefundStatusResponse> getResultList() {
			return this.resultList;
		}
		public void setResultList(List<QueryRefundStatusResponse> resultList) {
			this.resultList = resultList;
		}

}



}
