package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: tmall.item.hscode.audit.results.query response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TmallItemHscodeAuditResultsQueryResponse extends TaobaoResponse {

	private static final long serialVersionUID = 4188825817675155442L;

	/** 
	 * 商品或sku的hscode信息审核状态。
	 */
	@ApiListField("result_list")
	@ApiField("hscode_audit_info")
	private List<HscodeAuditInfo> resultList;


	public void setResultList(List<HscodeAuditInfo> resultList) {
		this.resultList = resultList;
	}
	public List<HscodeAuditInfo> getResultList( ) {
		return this.resultList;
	}
	
	/**
 * 商品或sku的hscode信息审核状态。
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class HscodeAuditInfo extends TaobaoObject {

	private static final long serialVersionUID = 3784839168942297852L;

	/**
		 * 商品或SKU使用的HS海关代码
		 */
		@ApiField("hscode")
		private String hscode;
		/**
		 * 商品ID
		 */
		@ApiField("item_id")
		private Long itemId;
		/**
		 * hscode信息当前审核状态的具体说明
		 */
		@ApiField("reason")
		private String reason;
		/**
		 * SKU的ID
		 */
		@ApiField("sku_id")
		private Long skuId;
		/**
		 * hscode信息当前审核状态，HISTORY_ITEM：历史已上架商品，REJECT：审核未通过，AUDITING：审核中，PASS：审核通过，ERROR：获取审核状态异常
		 */
		@ApiField("status")
		private String status;
	

	public String getHscode() {
			return this.hscode;
		}
		public void setHscode(String hscode) {
			this.hscode = hscode;
		}
		public Long getItemId() {
			return this.itemId;
		}
		public void setItemId(Long itemId) {
			this.itemId = itemId;
		}
		public String getReason() {
			return this.reason;
		}
		public void setReason(String reason) {
			this.reason = reason;
		}
		public Long getSkuId() {
			return this.skuId;
		}
		public void setSkuId(Long skuId) {
			this.skuId = skuId;
		}
		public String getStatus() {
			return this.status;
		}
		public void setStatus(String status) {
			this.status = status;
		}

}



}
