package com.taobao.api.response;

import java.util.List;
import com.taobao.api.internal.mapping.ApiField;
import com.taobao.api.internal.mapping.ApiListField;
import com.taobao.api.TaobaoObject;
import java.util.Date;

import com.taobao.api.TaobaoResponse;

/**
 * TOP API: taobao.top.oaid.decrypt response.
 * 
 * @author top auto create
 * @since 1.0, null
 */
public class TopOaidDecryptResponse extends TaobaoResponse {

	private static final long serialVersionUID = 5236975671458363922L;

	/** 
	 * 收件人列表
	 */
	@ApiListField("receiver_list")
	@ApiField("receiver")
	private List<Receiver> receiverList;


	public void setReceiverList(List<Receiver> receiverList) {
		this.receiverList = receiverList;
	}
	public List<Receiver> getReceiverList( ) {
		return this.receiverList;
	}
	
	/**
 * 收件人列表
 *
 * @author top auto create
 * @since 1.0, null
 */
public static class Receiver extends TaobaoObject {

	private static final long serialVersionUID = 3328549998628348195L;

	/**
		 * 收件人的详细地址
		 */
		@ApiField("address_detail")
		private String addressDetail;
		/**
		 * 收货人的所在城市
		 */
		@ApiField("city")
		private String city;
		/**
		 * 收货人国籍
		 */
		@ApiField("country")
		private String country;
		/**
		 * 收货人的所在地区
		 */
		@ApiField("district")
		private String district;
		/**
		 * oaid是否和tid当前的oaid匹配。true：匹配，false：不匹配。当不匹配时，建议通过taobao.trade.fullinfo.get获取最新的oaid。
		 */
		@ApiField("matched")
		private Boolean matched;
		/**
		 * 收件人的手机号，privacy_protection=true是为隐私号，格式为18877771111-123
		 */
		@ApiField("mobile")
		private String mobile;
		/**
		 * 收件人的姓名
		 */
		@ApiField("name")
		private String name;
		/**
		 * 收件人ID (Open Addressee ID)，长度在128个字符之内。
		 */
		@ApiField("oaid")
		private String oaid;
		/**
		 * 收件人的电话号码
		 */
		@ApiField("phone")
		private String phone;
		/**
		 * 标记订单是否为隐私保护订单，为true时，mobile为隐私号
		 */
		@ApiField("privacy_protection")
		private Boolean privacyProtection;
		/**
		 * 隐私号过期时间，privacy_protection=true时有值
		 */
		@ApiField("secret_no_expire_time")
		private Date secretNoExpireTime;
		/**
		 * 收货人的所在省份
		 */
		@ApiField("state")
		private String state;
		/**
		 * 交易编号
		 */
		@ApiField("tid")
		private String tid;
		/**
		 * 收货人街道地址
		 */
		@ApiField("town")
		private String town;
	

	public String getAddressDetail() {
			return this.addressDetail;
		}
		public void setAddressDetail(String addressDetail) {
			this.addressDetail = addressDetail;
		}
		public String getCity() {
			return this.city;
		}
		public void setCity(String city) {
			this.city = city;
		}
		public String getCountry() {
			return this.country;
		}
		public void setCountry(String country) {
			this.country = country;
		}
		public String getDistrict() {
			return this.district;
		}
		public void setDistrict(String district) {
			this.district = district;
		}
		public Boolean getMatched() {
			return this.matched;
		}
		public void setMatched(Boolean matched) {
			this.matched = matched;
		}
		public String getMobile() {
			return this.mobile;
		}
		public void setMobile(String mobile) {
			this.mobile = mobile;
		}
		public String getName() {
			return this.name;
		}
		public void setName(String name) {
			this.name = name;
		}
		public String getOaid() {
			return this.oaid;
		}
		public void setOaid(String oaid) {
			this.oaid = oaid;
		}
		public String getPhone() {
			return this.phone;
		}
		public void setPhone(String phone) {
			this.phone = phone;
		}
		public Boolean getPrivacyProtection() {
			return this.privacyProtection;
		}
		public void setPrivacyProtection(Boolean privacyProtection) {
			this.privacyProtection = privacyProtection;
		}
		public Date getSecretNoExpireTime() {
			return this.secretNoExpireTime;
		}
		public void setSecretNoExpireTime(Date secretNoExpireTime) {
			this.secretNoExpireTime = secretNoExpireTime;
		}
		public String getState() {
			return this.state;
		}
		public void setState(String state) {
			this.state = state;
		}
		public String getTid() {
			return this.tid;
		}
		public void setTid(String tid) {
			this.tid = tid;
		}
		public String getTown() {
			return this.town;
		}
		public void setTown(String town) {
			this.town = town;
		}

}



}
